/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.spi.ras;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.validation.constraints.NotNull;

public class ResultArchiveStorePath
implements Path {
    protected final FileSystem fileSystem;
    protected final List<String> nameElements = new ArrayList<String>();
    protected final boolean absolute;

    protected ResultArchiveStorePath(@NotNull FileSystem fileSystem, String path) {
        this.fileSystem = fileSystem;
        if (path == null) {
            throw new NullPointerException();
        }
        while (path.contains("//")) {
            path = path.replaceAll("\\Q//\\E", "/");
        }
        while (path.contains("\\")) {
            path = path.replaceAll("\\Q\\\\E", "/");
        }
        this.absolute = path.startsWith("/");
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        int firstChar = -1;
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) == '/') {
                if (firstChar == -1) continue;
                this.nameElements.add(path.substring(firstChar, i));
                firstChar = -1;
                continue;
            }
            if (firstChar != -1) continue;
            firstChar = i;
        }
        if (firstChar >= 0) {
            this.nameElements.add(path.substring(firstChar, path.length()));
        }
        for (String part : this.nameElements) {
            if (".".equals(part)) {
                throw new InvalidPathException(path, "Path parts of '.' are not allowed");
            }
            if ("..".equals(part)) {
                throw new InvalidPathException(path, "Path parts of '..' are not allowed");
            }
            if (part.contains("~")) {
                throw new InvalidPathException(path, "Path parts with '~' are not allowed");
            }
            if (!part.contains("=")) continue;
            throw new InvalidPathException(path, "Path parts with '=' are not allowed");
        }
        try {
            this.toUri();
        }
        catch (AssertionError e) {
            throw new AssertionError("Invalid path, would have conversion to URI", (Throwable)((Object)e));
        }
    }

    protected ResultArchiveStorePath(FileSystem fileSystem, boolean absolute, List<String> nameElements, int start, int end) {
        this.fileSystem = fileSystem;
        this.absolute = absolute;
        for (int i = start; i < end; ++i) {
            this.nameElements.add(nameElements.get(i));
        }
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public Path getRoot() {
        return this.newPathObject(true, new ArrayList<String>(), 0, 0);
    }

    @Override
    public Path getFileName() {
        if (this.nameElements.isEmpty()) {
            return null;
        }
        return new ResultArchiveStorePath(this.fileSystem, this.nameElements.get(this.nameElements.size() - 1));
    }

    @Override
    public Path getParent() {
        if (this.nameElements.isEmpty()) {
            return null;
        }
        return this.newPathObject(this.absolute, this.nameElements, 0, this.nameElements.size() - 1);
    }

    @Override
    public int getNameCount() {
        return this.nameElements.size();
    }

    @Override
    public Path getName(int index) {
        if (index < 0 || index >= this.nameElements.size()) {
            return null;
        }
        return this.newPathObject(this.nameElements.get(index));
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        if (endIndex <= beginIndex) {
            return null;
        }
        if (beginIndex < 0 || beginIndex >= this.nameElements.size()) {
            return null;
        }
        if (endIndex >= this.nameElements.size()) {
            return null;
        }
        boolean newAbolute = this.absolute;
        if (beginIndex > 0) {
            newAbolute = false;
        }
        return this.newPathObject(newAbolute, this.nameElements, beginIndex, endIndex);
    }

    @Override
    public boolean startsWith(Path other) {
        ResultArchiveStorePath o = this.checkPath(other);
        if (this.absolute != o.absolute) {
            return false;
        }
        if (o.nameElements.size() > this.nameElements.size()) {
            return false;
        }
        for (int i = 0; i < o.nameElements.size(); ++i) {
            if (o.nameElements.get(i).equals(this.nameElements.get(i))) continue;
            return false;
        }
        return true;
    }

    private ResultArchiveStorePath checkPath(Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!(path instanceof ResultArchiveStorePath)) {
            throw new ProviderMismatchException();
        }
        return (ResultArchiveStorePath)path;
    }

    @Override
    public boolean startsWith(String other) {
        return this.startsWith(this.newPathObject(other));
    }

    @Override
    public boolean endsWith(Path other) {
        ResultArchiveStorePath o = this.checkPath(other);
        if (o.nameElements.size() > this.nameElements.size()) {
            return false;
        }
        if (o.nameElements.size() == this.nameElements.size() && o.absolute != this.absolute) {
            return false;
        }
        int i = o.nameElements.size() - 1;
        int j = this.nameElements.size() - 1;
        while (i >= 0) {
            if (!o.nameElements.get(i).equals(this.nameElements.get(j))) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    @Override
    public boolean endsWith(String other) {
        return this.endsWith(this.newPathObject(other));
    }

    @Override
    public Path normalize() {
        return this;
    }

    @Override
    public Path resolve(Path other) {
        ResultArchiveStorePath o = this.checkPath(other);
        if (o.absolute) {
            return o;
        }
        ArrayList<String> combined = new ArrayList<String>(this.nameElements);
        combined.addAll(o.nameElements);
        return this.newPathObject(this.absolute, combined, 0, combined.size());
    }

    @Override
    public Path resolve(String other) {
        return this.resolve(this.newPathObject(other));
    }

    @Override
    public Path resolveSibling(Path other) {
        ResultArchiveStorePath o = this.checkPath(other);
        if (o.absolute || this.nameElements.isEmpty()) {
            return o;
        }
        ArrayList<String> combined = new ArrayList<String>(this.nameElements);
        combined.remove(combined.size() - 1);
        combined.addAll(o.nameElements);
        return this.newPathObject(this.absolute, combined, 0, combined.size());
    }

    @Override
    public Path resolveSibling(String other) {
        return this.resolveSibling(this.newPathObject(other));
    }

    @Override
    public Path relativize(Path other) {
        ResultArchiveStorePath o = this.checkPath(other);
        if (o.absolute && !this.absolute) {
            return o;
        }
        if (this.absolute && !o.absolute) {
            return null;
        }
        if (this.equals(o)) {
            return this.newPathObject("");
        }
        if (!o.startsWith(this)) {
            return null;
        }
        return this.newPathObject(false, o.nameElements, this.nameElements.size(), o.nameElements.size());
    }

    @Override
    public URI toUri() {
        try {
            return new URI(this.fileSystem.provider().getScheme() + ":" + this.toAbsolutePath().toString());
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public String toString() {
        if (this.absolute && this.nameElements.isEmpty()) {
            return "/";
        }
        StringBuilder sb = new StringBuilder();
        boolean prefixSeperator = this.absolute;
        for (String element : this.nameElements) {
            if (prefixSeperator) {
                sb.append("/");
            }
            sb.append(element);
            prefixSeperator = true;
        }
        return sb.toString();
    }

    @Override
    public Path toAbsolutePath() {
        if (this.absolute) {
            return this;
        }
        return this.newPathObject(true, this.nameElements, 0, this.nameElements.size());
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        return null;
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException("Unable to translate to a java.ioFile");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException("Watching is not supported with this filesystem");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        throw new UnsupportedOperationException("Watching is not supported with this filesystem");
    }

    @Override
    public Iterator<Path> iterator() {
        ArrayList<ResultArchiveStorePath> it = new ArrayList<ResultArchiveStorePath>();
        for (String element : this.nameElements) {
            it.add(this.newPathObject(element));
        }
        return it.iterator();
    }

    @Override
    public int compareTo(Path other) {
        if (!(other instanceof ResultArchiveStorePath)) {
            throw new ProviderMismatchException();
        }
        ResultArchiveStorePath o = (ResultArchiveStorePath)other;
        if (this.nameElements.isEmpty() && o.nameElements.isEmpty()) {
            return 0;
        }
        if (this.nameElements.isEmpty()) {
            return -1;
        }
        if (o.nameElements.isEmpty()) {
            return 1;
        }
        int maxSize = Math.max(this.nameElements.size(), o.nameElements.size());
        for (int i = 0; i < maxSize; ++i) {
            if (i >= this.nameElements.size()) {
                return -1;
            }
            if (i >= o.nameElements.size()) {
                return 1;
            }
            int c = this.nameElements.get(i).compareTo(o.nameElements.get(i));
            if (c < 0) {
                return -1;
            }
            if (c <= 0) continue;
            return 1;
        }
        return 0;
    }

    public ResultArchiveStorePath unAbsolute() {
        if (!this.absolute) {
            return this;
        }
        return this.newPathObject(false, this.nameElements, 0, this.nameElements.size());
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    protected ResultArchiveStorePath newPathObject(String newPath) {
        return new ResultArchiveStorePath(this.fileSystem, newPath);
    }

    protected ResultArchiveStorePath newPathObject(boolean absolute, List<String> nameElements, int start, int end) {
        return new ResultArchiveStorePath(this.fileSystem, absolute, nameElements, start, end);
    }
}

