/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.spi.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import dev.galasa.framework.spi.utils.GalasaGsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.apache.commons.io.output.StringBuilderWriter;

public class GalasaGson {
    private GalasaGsonBuilder galasaGsonBuilder = new GalasaGsonBuilder();
    private Gson gson = this.galasaGsonBuilder.getGson();

    public Gson getGson() {
        return this.gson;
    }

    public GalasaGsonBuilder getGsonBuilder() {
        return this.galasaGsonBuilder;
    }

    public void setGsonBuilder(GalasaGsonBuilder builder) {
        this.galasaGsonBuilder = builder;
        this.gson = this.galasaGsonBuilder.getGson();
    }

    public String toJson(Object obj) {
        return this.gson.toJson(obj);
    }

    public <T> T fromJson(String json, Class<T> classOfT) {
        return (T)this.gson.fromJson(json, classOfT);
    }

    public <T> T fromJson(InputStreamReader inputStreamReader, Class<T> classOfT) throws IOException {
        return this.fromJson(this.readerToString(inputStreamReader), classOfT);
    }

    public <T> T fromJson(JsonObject jsonObject, Class<T> classOfT) {
        return (T)this.gson.fromJson((JsonElement)jsonObject, classOfT);
    }

    public <T> T fromJson(JsonReader jsonReader, Class<T> classOfT) {
        return (T)this.gson.fromJson(jsonReader, classOfT);
    }

    public JsonObject fromJson(BufferedReader bufferedReader, Class<JsonObject> classOfT) throws IOException {
        return this.fromJson(this.readerToString(bufferedReader), classOfT);
    }

    public JsonElement toJsonTree(Object obj) {
        return this.gson.toJsonTree(obj);
    }

    public JsonReader newJsonReader(StringReader stringReader) {
        return this.gson.newJsonReader((Reader)stringReader);
    }

    private String readerToString(Reader reader) throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter();
        reader.transferTo((Writer)writer);
        return writer.toString();
    }
}

