/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.selenium;

import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.selenium.SeleniumManagerException;
import dev.galasa.selenium.internal.properties.SeleniumAvailableDrivers;
import dev.galasa.selenium.internal.properties.SeleniumDockerNodeVersion;
import java.security.SecureRandom;

public enum Browser {
    FIREFOX,
    OPERA,
    IE,
    CHROME,
    EDGE,
    ANYAVAIALBLE,
    NOTSPECIFIED;

    private Browser selected;

    public String getDockerImageName() throws SeleniumManagerException {
        String version = SeleniumDockerNodeVersion.get();
        switch (this) {
            case FIREFOX: {
                return "selenium/standalone-firefox:" + version;
            }
            case OPERA: {
                return "selenium/standalone-opera:" + version;
            }
            case CHROME: {
                return "selenium/standalone-chrome:" + version;
            }
            case EDGE: {
                return "selenium/standalone-edge:" + version;
            }
            case ANYAVAIALBLE: {
                if (this.selected == null) {
                    this.selectAvailableDriver();
                }
                return this.selected.getDockerImageName();
            }
            case NOTSPECIFIED: {
                return null;
            }
        }
        throw new SeleniumManagerException("Unsupported browser. Available docker nodes: Firefox, Chrome, Opera, Edge");
    }

    public String getDriverName() throws SeleniumManagerException {
        switch (this) {
            case FIREFOX: {
                return "firefox";
            }
            case OPERA: {
                return "opera";
            }
            case CHROME: {
                return "chrome";
            }
            case EDGE: {
                return "MicrosoftEdge";
            }
            case IE: {
                return "internet explorer";
            }
            case ANYAVAIALBLE: {
                if (this.selected == null) {
                    this.selectAvailableDriver();
                }
                return this.selected.getDriverName();
            }
            case NOTSPECIFIED: {
                return null;
            }
        }
        throw new SeleniumManagerException("Unsupported driver name.");
    }

    private void selectAvailableDriver() throws SeleniumManagerException {
        try {
            String[] availabledrivers = SeleniumAvailableDrivers.get();
            if (availabledrivers.length < 1) {
                throw new SeleniumManagerException("No available drivers");
            }
            SecureRandom rand = new SecureRandom();
            this.selected = Browser.valueOf(availabledrivers[rand.nextInt(availabledrivers.length)]);
        }
        catch (ConfigurationPropertyStoreException e) {
            throw new SeleniumManagerException("Failed to find avilable drivers", e);
        }
    }
}

