/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.selenium.internal;

import dev.galasa.selenium.Browser;
import dev.galasa.selenium.IChromeOptions;
import dev.galasa.selenium.IEdgeOptions;
import dev.galasa.selenium.IFirefoxOptions;
import dev.galasa.selenium.IInternetExplorerOptions;
import dev.galasa.selenium.IOperaOptions;
import dev.galasa.selenium.IWebDriver;
import dev.galasa.selenium.IWebPage;
import dev.galasa.selenium.SeleniumManagerException;
import dev.galasa.selenium.internal.ChromeOptionsImpl;
import dev.galasa.selenium.internal.DriverImpl;
import dev.galasa.selenium.internal.EdgeOptionsImpl;
import dev.galasa.selenium.internal.FirefoxOptionsImpl;
import dev.galasa.selenium.internal.InternetExplorerOptionsImpl;
import dev.galasa.selenium.internal.LocalBrowser;
import dev.galasa.selenium.internal.OperaOptionsImpl;
import dev.galasa.selenium.internal.SeleniumManagerImpl;
import java.nio.file.Path;
import org.openqa.selenium.WebDriver;

public class LocalDriverImpl
extends DriverImpl
implements IWebDriver {
    private Path screenshotRasDirectory;
    private Browser browser;
    private SeleniumManagerImpl seleniumManager;

    public LocalDriverImpl(SeleniumManagerImpl seleniumManager, Browser browser, Path screenshotRasDirectory) throws SeleniumManagerException {
        this.seleniumManager = seleniumManager;
        this.screenshotRasDirectory = screenshotRasDirectory;
        this.browser = browser;
    }

    @Override
    public IWebPage allocateWebPage() throws SeleniumManagerException {
        return this.allocateWebPage(null);
    }

    @Override
    public IWebPage allocateWebPage(String url) throws SeleniumManagerException {
        WebDriver driver = null;
        try {
            driver = LocalBrowser.getWebDriver(this.browser);
            if (driver == null) {
                throw new SeleniumManagerException("Unsupported driver type " + this.browser.getDriverName());
            }
        }
        catch (SeleniumManagerException e) {
            throw new SeleniumManagerException("Issue provisioning web driver", (Throwable)((Object)e));
        }
        return this.allocatePage(this.seleniumManager, driver, url, this.screenshotRasDirectory);
    }

    @Override
    public IWebPage allocateWebPage(String url, IFirefoxOptions options) throws SeleniumManagerException {
        WebDriver driver = null;
        try {
            driver = LocalBrowser.getGeckoDriver(options);
            if (driver == null) {
                throw new SeleniumManagerException("Unsupported driver type: " + this.browser.getDriverName());
            }
        }
        catch (SeleniumManagerException e) {
            throw new SeleniumManagerException("Issue provisioning web driver", (Throwable)((Object)e));
        }
        return this.allocatePage(this.seleniumManager, driver, url, this.screenshotRasDirectory);
    }

    @Override
    public IWebPage allocateWebPage(String url, IChromeOptions options) throws SeleniumManagerException {
        WebDriver driver = null;
        try {
            driver = LocalBrowser.getChromeDriver(((ChromeOptionsImpl)options).get());
            if (driver == null) {
                throw new SeleniumManagerException("Unsupported driver type: " + this.browser.getDriverName());
            }
        }
        catch (SeleniumManagerException e) {
            throw new SeleniumManagerException("Issue provisioning web driver", (Throwable)((Object)e));
        }
        return this.allocatePage(this.seleniumManager, driver, url, this.screenshotRasDirectory);
    }

    @Override
    public IWebPage allocateWebPage(String url, IEdgeOptions options) throws SeleniumManagerException {
        WebDriver driver = null;
        try {
            driver = LocalBrowser.getEdgeDriver(((EdgeOptionsImpl)options).get());
            if (driver == null) {
                throw new SeleniumManagerException("Unsupported driver type: " + this.browser.getDriverName());
            }
        }
        catch (SeleniumManagerException e) {
            throw new SeleniumManagerException("Issue provisioning web driver", (Throwable)((Object)e));
        }
        return this.allocatePage(this.seleniumManager, driver, url, this.screenshotRasDirectory);
    }

    @Override
    public IWebPage allocateWebPage(String url, IInternetExplorerOptions options) throws SeleniumManagerException {
        WebDriver driver = null;
        try {
            driver = LocalBrowser.getIEDriver(((InternetExplorerOptionsImpl)options).get());
            if (driver == null) {
                throw new SeleniumManagerException("Unsupported driver type:" + this.browser.getDriverName());
            }
        }
        catch (SeleniumManagerException e) {
            throw new SeleniumManagerException("Issue provisioning web driver", (Throwable)((Object)e));
        }
        return this.allocatePage(this.seleniumManager, driver, url, this.screenshotRasDirectory);
    }

    @Override
    public IWebPage allocateWebPage(String url, IOperaOptions options) throws SeleniumManagerException {
        WebDriver driver = null;
        try {
            driver = LocalBrowser.getOperaDriver(((OperaOptionsImpl)options).get());
            if (driver == null) {
                throw new SeleniumManagerException("Unsupported driver type:" + this.browser.getDriverName());
            }
        }
        catch (SeleniumManagerException e) {
            throw new SeleniumManagerException("Issue provisioning web driver", (Throwable)((Object)e));
        }
        return this.allocatePage(this.seleniumManager, driver, url, this.screenshotRasDirectory);
    }

    @Override
    public IFirefoxOptions getFirefoxOptions() {
        return new FirefoxOptionsImpl();
    }

    @Override
    public IChromeOptions getChromeOptions() {
        return new ChromeOptionsImpl();
    }

    @Override
    public IEdgeOptions getEdgeOptions() {
        return new EdgeOptionsImpl();
    }

    @Override
    public IOperaOptions getOperaOptions() {
        return new OperaOptionsImpl();
    }

    @Override
    public IInternetExplorerOptions getInternetExplorerOptions() {
        return new InternetExplorerOptionsImpl();
    }

    @Override
    public void discard() {
        this.discardPages();
    }
}

