/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.selenium.internal;

import dev.galasa.artifact.IArtifactManager;
import dev.galasa.artifact.IBundleResources;
import dev.galasa.artifact.TestBundleResourceException;
import dev.galasa.docker.DockerManagerException;
import dev.galasa.docker.IDockerContainer;
import dev.galasa.docker.spi.IDockerManagerSpi;
import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.http.HttpClientException;
import dev.galasa.http.HttpClientResponse;
import dev.galasa.http.IHttpClient;
import dev.galasa.http.spi.IHttpManagerSpi;
import dev.galasa.kubernetes.IDeployment;
import dev.galasa.kubernetes.IKubernetesNamespace;
import dev.galasa.kubernetes.IService;
import dev.galasa.kubernetes.spi.IKubernetesManagerSpi;
import dev.galasa.selenium.Browser;
import dev.galasa.selenium.IChromeOptions;
import dev.galasa.selenium.IEdgeOptions;
import dev.galasa.selenium.IFirefoxOptions;
import dev.galasa.selenium.IInternetExplorerOptions;
import dev.galasa.selenium.IOperaOptions;
import dev.galasa.selenium.IWebDriver;
import dev.galasa.selenium.IWebPage;
import dev.galasa.selenium.SeleniumManagerException;
import dev.galasa.selenium.internal.ChromeOptionsImpl;
import dev.galasa.selenium.internal.DriverImpl;
import dev.galasa.selenium.internal.EdgeOptionsImpl;
import dev.galasa.selenium.internal.FirefoxOptionsImpl;
import dev.galasa.selenium.internal.InternetExplorerOptionsImpl;
import dev.galasa.selenium.internal.OperaOptionsImpl;
import dev.galasa.selenium.internal.SeleniumEnvironment;
import dev.galasa.selenium.internal.SeleniumManagerImpl;
import dev.galasa.selenium.internal.WebPageImpl;
import dev.galasa.selenium.internal.properties.SeleniumGridEndpoint;
import dev.galasa.selenium.internal.properties.SeleniumKubernetesNamespace;
import dev.galasa.selenium.internal.properties.SeleniumKubernetesNodeSelector;
import dev.galasa.selenium.internal.properties.SeleniumWebDriverType;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class RemoteDriverImpl
extends DriverImpl
implements IWebDriver {
    private static final Log logger = LogFactory.getLog(RemoteDriverImpl.class);
    private List<WebPageImpl> webPages = new ArrayList<WebPageImpl>();
    private URL remoteDriverEndpoint;
    private Path screenshotRasDirectory;
    private Browser browser;
    private SeleniumManagerImpl seleniumManager;
    private IDynamicStatusStoreService dss;
    private SeleniumEnvironment seleniumEnvironment;
    private String driverSlotName;
    private String k8sRunName;

    public RemoteDriverImpl(SeleniumEnvironment seleniumEnvironment, SeleniumManagerImpl seleniumManager, Browser browser, String slotName, Path screenshotRasDirectory) throws SeleniumManagerException {
        this.seleniumEnvironment = seleniumEnvironment;
        this.seleniumManager = seleniumManager;
        this.browser = browser;
        this.driverSlotName = slotName;
        this.screenshotRasDirectory = screenshotRasDirectory;
        this.dss = seleniumManager.getDss();
        try {
            switch (SeleniumWebDriverType.get()) {
                case "docker": {
                    this.provisionDocker(seleniumManager.getDockerManager(), seleniumManager.getHttpManager());
                    break;
                }
                case "kubernetes": {
                    this.k8sRunName = slotName.replace("_", "-").toLowerCase();
                    this.provisionK8s(seleniumManager.getKubernetesManager(), seleniumManager.getArtifactManager(), seleniumManager.getHttpManager());
                    break;
                }
                case "grid": {
                    this.provisionGrid(seleniumManager.getHttpManager());
                    break;
                }
                default: {
                    throw new SeleniumManagerException("Unsupported Driver Type: " + SeleniumWebDriverType.get());
                }
            }
        }
        catch (ConfigurationPropertyStoreException e) {
            throw new SeleniumManagerException("Failed to create remote driver", e);
        }
    }

    private void provisionGrid(IHttpManagerSpi httpManager) throws SeleniumManagerException {
        try {
            this.remoteDriverEndpoint = new URL(SeleniumGridEndpoint.get());
            IHttpClient client = httpManager.newHttpClient();
            client.setURI(this.remoteDriverEndpoint.toURI());
            HttpClientResponse resp = client.getJson("/status");
            if (resp.getStatusCode() > 200) {
                throw new SeleniumManagerException("Bad response from Grid: " + resp.getStatusLine());
            }
        }
        catch (ConfigurationPropertyStoreException | HttpClientException | MalformedURLException | URISyntaxException e) {
            throw new SeleniumManagerException("Failed to provision a Grid Driver.", e);
        }
    }

    private void provisionDocker(IDockerManagerSpi dockerManager, IHttpManagerSpi httpManager) throws SeleniumManagerException {
        try {
            IDockerContainer container = dockerManager.provisionContainer("Selenium_Standalone_node_" + this.driverSlotName, this.browser.getDockerImageName(), true, "PRIMARY");
            List dockerEndpoint = (List)container.getExposedPorts().get("4444/tcp");
            this.remoteDriverEndpoint = new URL("http:/" + dockerEndpoint.get(0));
            IHttpClient client = httpManager.newHttpClient();
            client.setURI(this.remoteDriverEndpoint.toURI());
            for (int i = 0; i < 5; ++i) {
                block5: {
                    try {
                        Thread.sleep(2000L);
                        HttpClientResponse resp = client.getJson("/status");
                        if (resp.getStatusCode() >= 202) break block5;
                        break;
                    }
                    catch (HttpClientException e) {
                        continue;
                    }
                }
                throw new SeleniumManagerException("Selenium node failed to become ready");
            }
        }
        catch (DockerManagerException | InterruptedException | MalformedURLException | URISyntaxException e) {
            throw new SeleniumManagerException(e);
        }
    }

    private void provisionK8s(IKubernetesManagerSpi k8Manager, IArtifactManager artifactManager, IHttpManagerSpi httpManager) throws SeleniumManagerException {
        String seleniumPodYaml = this.generatePodYaml(artifactManager);
        String seleniumServiceYaml = this.generateServiceYaml(artifactManager);
        try {
            IKubernetesNamespace namespace = k8Manager.getNamespaceByTag(SeleniumKubernetesNamespace.get());
            IService service = (IService)namespace.createResource(seleniumServiceYaml);
            IDeployment pod = (IDeployment)namespace.createResource(seleniumPodYaml);
            InetSocketAddress socket = service.getSocketAddressForPort(4444);
            this.remoteDriverEndpoint = new URL("http://" + socket.getHostString() + ":" + Integer.toString(socket.getPort()));
            IHttpClient client = httpManager.newHttpClient();
            client.setURI(this.remoteDriverEndpoint.toURI());
            for (int i = 0; i <= 10; ++i) {
                try {
                    if (client.getJson("/status").getStatusCode() != 200) continue;
                    logger.debug((Object)("Connected to grid at: " + this.remoteDriverEndpoint));
                    return;
                }
                catch (HttpClientException e) {
                    Thread.sleep(5000L);
                    logger.debug((Object)"Failed to reach node endpoint. Retrying in 5 seconds");
                }
            }
        }
        catch (Exception e) {
            throw new SeleniumManagerException("Unable to provision K8 node", e);
        }
        throw new SeleniumManagerException("Selenium Node took too long to ready.");
    }

    private String generateServiceYaml(IArtifactManager artifacts) throws SeleniumManagerException {
        IBundleResources resources = artifacts.getBundleResources(this.getClass());
        logger.trace((Object)"Generating Service Yaml");
        try {
            String yaml = resources.retrieveFileAsString("resources/selenium-node-expose.yaml");
            String runName = this.seleniumManager.getFramework().getTestRunName();
            yaml = yaml.replace("<RUNNAME>", this.k8sRunName);
            logger.trace((Object)yaml);
            return yaml;
        }
        catch (TestBundleResourceException | IOException e) {
            throw new SeleniumManagerException("Failed to generate service yaml", e);
        }
    }

    private String generatePodYaml(IArtifactManager artifacts) throws SeleniumManagerException {
        logger.trace((Object)"Generating Pod Yaml");
        IBundleResources resources = artifacts.getBundleResources(this.getClass());
        try {
            String yaml = resources.retrieveFileAsString("resources/selenium-node-deployment.yaml");
            yaml = yaml.replace("<IMAGE_NAME>", this.browser.getDockerImageName());
            String runName = this.seleniumManager.getFramework().getTestRunName();
            yaml = yaml.replace("<RUNNAME>", this.k8sRunName);
            Object nodeSelectors = "";
            String[] selectors = SeleniumKubernetesNodeSelector.get();
            if (selectors.length > 1) {
                nodeSelectors = (String)nodeSelectors + "      nodeSelector:\n";
                for (String selector : selectors) {
                    nodeSelectors = (String)nodeSelectors + "        " + selector + "\n";
                }
            }
            yaml = yaml.replace("<NODE_SELECTOR>", (CharSequence)nodeSelectors);
            logger.trace((Object)yaml);
            return yaml;
        }
        catch (TestBundleResourceException | ConfigurationPropertyStoreException | IOException e) {
            throw new SeleniumManagerException("Unable to generate pod yaml", e);
        }
    }

    private RemoteWebDriver remoteDriver() throws SeleniumManagerException {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        capabilities.setBrowserName(this.browser.getDriverName());
        capabilities.setCapability("GALASA", "GALASA");
        RemoteWebDriver driver = new RemoteWebDriver(this.remoteDriverEndpoint, (Capabilities)capabilities);
        try {
            if (this.dss.get("driver.slot." + this.driverSlotName + ".session") == null) {
                this.dss.put("driver.slot." + this.driverSlotName + ".session", driver.getSessionId().toString());
            } else {
                this.discard();
                this.dss.put("driver.slot." + this.driverSlotName + ".session", driver.getSessionId().toString());
            }
        }
        catch (DynamicStatusStoreException e) {
            throw new SeleniumManagerException("Failed to set session to a slot", e);
        }
        return driver;
    }

    private RemoteWebDriver remoteDriver(DesiredCapabilities capabilities) throws SeleniumManagerException {
        capabilities.setBrowserName(this.browser.getDriverName());
        return new RemoteWebDriver(this.remoteDriverEndpoint, (Capabilities)capabilities);
    }

    @Override
    public IWebPage allocateWebPage() throws SeleniumManagerException {
        return this.allocateWebPage(null);
    }

    @Override
    public IWebPage allocateWebPage(String url) throws SeleniumManagerException {
        RemoteWebDriver driver = null;
        try {
            driver = this.remoteDriver();
            if (driver == null) {
                throw new SeleniumManagerException("Unsupported driver type: " + this.browser.getDriverName());
            }
        }
        catch (SeleniumManagerException e) {
            throw new SeleniumManagerException("Issue provisioning web driver", (Throwable)((Object)e));
        }
        return this.allocatePage(this.seleniumManager, driver, url, this.screenshotRasDirectory);
    }

    @Override
    public IWebPage allocateWebPage(String url, IFirefoxOptions options) throws SeleniumManagerException {
        RemoteWebDriver driver = null;
        try {
            driver = this.remoteDriver(new DesiredCapabilities((Capabilities)options.getOptions()));
            if (driver == null) {
                throw new SeleniumManagerException("Unsupported driver type: " + this.browser.getDriverName());
            }
        }
        catch (SeleniumManagerException e) {
            throw new SeleniumManagerException("Issue provisioning web driver", (Throwable)((Object)e));
        }
        return this.allocatePage(this.seleniumManager, driver, url, this.screenshotRasDirectory);
    }

    @Override
    public IWebPage allocateWebPage(String url, IChromeOptions options) throws SeleniumManagerException {
        RemoteWebDriver driver = null;
        try {
            driver = this.remoteDriver(new DesiredCapabilities((Capabilities)((ChromeOptionsImpl)options).get()));
            if (driver == null) {
                throw new SeleniumManagerException("Unsupported driver type: " + this.browser.getDriverName());
            }
        }
        catch (SeleniumManagerException e) {
            throw new SeleniumManagerException("Issue provisioning web driver", (Throwable)((Object)e));
        }
        return this.allocatePage(this.seleniumManager, driver, url, this.screenshotRasDirectory);
    }

    @Override
    public IWebPage allocateWebPage(String url, IEdgeOptions options) throws SeleniumManagerException {
        RemoteWebDriver driver = null;
        try {
            driver = this.remoteDriver(new DesiredCapabilities((Capabilities)((EdgeOptionsImpl)options).get()));
            if (driver == null) {
                throw new SeleniumManagerException("Unsupported driver type: " + this.browser.getDriverName());
            }
        }
        catch (SeleniumManagerException e) {
            throw new SeleniumManagerException("Issue provisioning web driver", (Throwable)((Object)e));
        }
        return this.allocatePage(this.seleniumManager, driver, url, this.screenshotRasDirectory);
    }

    @Override
    public IWebPage allocateWebPage(String url, IInternetExplorerOptions options) throws SeleniumManagerException {
        RemoteWebDriver driver = null;
        try {
            driver = this.remoteDriver(new DesiredCapabilities((Capabilities)((InternetExplorerOptionsImpl)options).get()));
            if (driver == null) {
                throw new SeleniumManagerException("Unsupported driver type: " + this.browser.getDriverName());
            }
        }
        catch (SeleniumManagerException e) {
            throw new SeleniumManagerException("Issue provisioning web driver", (Throwable)((Object)e));
        }
        return this.allocatePage(this.seleniumManager, driver, url, this.screenshotRasDirectory);
    }

    @Override
    public IWebPage allocateWebPage(String url, IOperaOptions options) throws SeleniumManagerException {
        RemoteWebDriver driver = null;
        try {
            driver = this.remoteDriver(new DesiredCapabilities((Capabilities)((OperaOptionsImpl)options).get()));
            if (driver == null) {
                throw new SeleniumManagerException("Unsupported driver type: " + this.browser.getDriverName());
            }
        }
        catch (SeleniumManagerException e) {
            throw new SeleniumManagerException("Issue provisioning web driver", (Throwable)((Object)e));
        }
        return this.allocatePage(this.seleniumManager, driver, url, this.screenshotRasDirectory);
    }

    @Override
    public IFirefoxOptions getFirefoxOptions() {
        return new FirefoxOptionsImpl();
    }

    @Override
    public IChromeOptions getChromeOptions() {
        return new ChromeOptionsImpl();
    }

    @Override
    public IEdgeOptions getEdgeOptions() {
        return new EdgeOptionsImpl();
    }

    @Override
    public IOperaOptions getOperaOptions() {
        return new OperaOptionsImpl();
    }

    @Override
    public IInternetExplorerOptions getInternetExplorerOptions() {
        return new InternetExplorerOptionsImpl();
    }

    @Override
    public void discard() {
        this.discardPages();
    }
}

