/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.selenium.internal;

import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.DssAdd;
import dev.galasa.framework.spi.DssDeletePrefix;
import dev.galasa.framework.spi.DssSwap;
import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.IDssAction;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.ResourceUnavailableException;
import dev.galasa.selenium.Browser;
import dev.galasa.selenium.ISeleniumManager;
import dev.galasa.selenium.IWebDriver;
import dev.galasa.selenium.IWebPage;
import dev.galasa.selenium.SeleniumManagerException;
import dev.galasa.selenium.internal.DriverImpl;
import dev.galasa.selenium.internal.LocalDriverImpl;
import dev.galasa.selenium.internal.RemoteDriverImpl;
import dev.galasa.selenium.internal.SeleniumManagerImpl;
import dev.galasa.selenium.internal.properties.SeleniumDefaultDriver;
import dev.galasa.selenium.internal.properties.SeleniumDriverMaxSlots;
import dev.galasa.selenium.internal.properties.SeleniumWebDriverType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SeleniumEnvironment {
    private static final Log logger = LogFactory.getLog(SeleniumEnvironment.class);
    private SeleniumManagerImpl seleniumManager;
    private Path screenshotRasDirectory;
    private List<String> slots = new ArrayList<String>();
    private List<ISeleniumManager> drivers = new ArrayList<ISeleniumManager>();
    private IDynamicStatusStoreService dss;
    private String runName;
    private int sessions = 0;

    public SeleniumEnvironment(SeleniumManagerImpl seleleniumManager, Path screenshotRasDirectory) throws SeleniumManagerException {
        this.seleniumManager = seleleniumManager;
        this.screenshotRasDirectory = screenshotRasDirectory;
        this.dss = seleleniumManager.getDss();
        this.runName = this.seleniumManager.getFramework().getTestRunName();
    }

    public ISeleniumManager allocateDriver(Browser browser) throws ResourceUnavailableException, SeleniumManagerException {
        DriverImpl driver;
        Path driverRasDir = this.screenshotRasDirectory;
        try {
            if (browser.equals((Object)Browser.NOTSPECIFIED)) {
                browser = Browser.valueOf(SeleniumDefaultDriver.get());
            }
            switch (SeleniumWebDriverType.get()) {
                case "local": {
                    driver = new LocalDriverImpl(this.seleniumManager, browser, driverRasDir);
                    break;
                }
                default: {
                    String slotName = this.allocateSlot();
                    driver = new RemoteDriverImpl(this, this.seleniumManager, browser, slotName, driverRasDir);
                    break;
                }
            }
        }
        catch (ConfigurationPropertyStoreException e) {
            throw new SeleniumManagerException("Failed to fetch Driver type", e);
        }
        this.drivers.add((ISeleniumManager)((Object)driver));
        return driver;
    }

    public IWebDriver allocateWebDriver(Browser browser) throws ResourceUnavailableException, SeleniumManagerException {
        DriverImpl driver;
        Path driverRasDir = this.screenshotRasDirectory;
        try {
            if (browser.equals((Object)Browser.NOTSPECIFIED)) {
                browser = Browser.valueOf(SeleniumDefaultDriver.get());
            }
            switch (SeleniumWebDriverType.get()) {
                case "local": {
                    driver = new LocalDriverImpl(this.seleniumManager, browser, driverRasDir);
                    break;
                }
                default: {
                    String slotName = this.allocateSlot();
                    driver = new RemoteDriverImpl(this, this.seleniumManager, browser, slotName, driverRasDir);
                    break;
                }
            }
        }
        catch (ConfigurationPropertyStoreException e) {
            throw new SeleniumManagerException("Failed to fetch Driver type", e);
        }
        this.drivers.add((ISeleniumManager)((Object)driver));
        return driver;
    }

    private String allocateSlot() throws ResourceUnavailableException, SeleniumManagerException {
        String slotKey = "driver.current.slots";
        String slots = "";
        Object slotName = "";
        int currentSlots = 0;
        DynamicStatusStoreException lastPerformActionsException = null;
        try {
            for (int i = 0; i < 50; ++i) {
                slots = this.dss.get(slotKey);
                if (slots != null) {
                    currentSlots = Integer.valueOf(slots);
                } else {
                    slots = "0";
                    this.dss.performActions(new IDssAction[]{new DssAdd(slotKey, slots)});
                    currentSlots = 0;
                }
                if (currentSlots >= SeleniumDriverMaxSlots.get()) {
                    throw new ResourceUnavailableException("Failed to provsion. No slots avilable");
                }
                String slotNamePrefix = "SeleniumSlot_" + this.runName + "_";
                String slotNameAttempt = slotNamePrefix + this.sessions;
                try {
                    this.dss.performActions(new IDssAction[]{new DssAdd("driver.slot." + slotNameAttempt, this.runName), new DssSwap(slotKey, slots, String.valueOf(++currentSlots))});
                    slotName = slotNameAttempt;
                    break;
                }
                catch (DynamicStatusStoreException e) {
                    logger.trace((Object)("Failed to get slot: " + slotNameAttempt + ". Retrying... "));
                    lastPerformActionsException = e;
                    continue;
                }
            }
            if ("".equals(slotName)) {
                throw new SeleniumManagerException("Unable to resolve a slot name", lastPerformActionsException);
            }
        }
        catch (ConfigurationPropertyStoreException | DynamicStatusStoreException e) {
            throw new SeleniumManagerException("Failed to allocate slot", e);
        }
        this.slots.add((String)slotName);
        ++this.sessions;
        return slotName;
    }

    public void screenShotPages() throws SeleniumManagerException {
        for (ISeleniumManager driver : this.drivers) {
            for (IWebPage page : driver.getPages()) {
                page.takeScreenShot();
            }
        }
    }

    public void discard() throws SeleniumManagerException {
        this.freeSlots();
    }

    public void closePages() throws SeleniumManagerException {
        for (ISeleniumManager driver : this.drivers) {
            driver.discard();
        }
    }

    private void freeSlots() throws SeleniumManagerException {
        ArrayList<Object> actions = new ArrayList<Object>();
        try {
            for (String slot : this.slots) {
                actions.add(new DssDeletePrefix("driver.slot." + slot));
            }
            int newSlots = 0;
            String currentSlots = this.dss.get("driver.current.slots");
            if (currentSlots != null) {
                newSlots = Integer.valueOf(currentSlots) - actions.size();
            }
            actions.add(new DssSwap("driver.current.slots", currentSlots, String.valueOf(newSlots)));
            this.dss.performActions(actions.toArray(new IDssAction[actions.size()]));
        }
        catch (DynamicStatusStoreException e) {
            throw new SeleniumManagerException("Failed to clean slots", e);
        }
    }
}

