/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.selenium.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.DssDelete;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IDssAction;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IResourceManagement;
import dev.galasa.http.HttpClientResponse;
import dev.galasa.http.IHttpClient;
import dev.galasa.http.StandAloneHttpClient;
import dev.galasa.selenium.SeleniumManagerException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SeleniumGridSessionMonitor
implements Runnable {
    private final IFramework framework;
    private final IResourceManagement resourceManagement;
    private final IDynamicStatusStoreService dss;
    private final IConfigurationPropertyStoreService cps;
    private final Log logger = LogFactory.getLog(SeleniumGridSessionMonitor.class);
    private final Pattern slotRunPattern = Pattern.compile("driver\\.slot\\.(.*)(?=\\.session)");
    private String gridEndpoint;

    public SeleniumGridSessionMonitor(IFramework framework, IResourceManagement resourceManagement, IDynamicStatusStoreService dss, IConfigurationPropertyStoreService cps) {
        this.framework = framework;
        this.dss = dss;
        this.cps = cps;
        this.resourceManagement = resourceManagement;
        this.logger.info((Object)"Selenium Grid Session monitor intialised");
    }

    @Override
    public void run() {
        this.logger.info((Object)"Starting search for stale sessions.");
        try {
            this.gridEndpoint = this.cps.getProperty("grid", "endpoint", new String[0]);
            if (this.gridEndpoint == null) {
                this.logger.info((Object)"No Selenium grid defined, finishing.");
                return;
            }
        }
        catch (ConfigurationPropertyStoreException e) {
            this.logger.error((Object)"Failed to retrieve grid endpoint, ending.");
            return;
        }
        this.checkForStaleSessions();
        this.logger.info((Object)"Finished search for stale sessions..");
    }

    public void checkForStaleSessions() {
        try {
            Map driverSlots = this.dss.getPrefix("driver.slot");
            Map<Object, Object> activeSeleniumSessions = new HashMap();
            IHttpClient client = StandAloneHttpClient.getHttpClient((int)3600, (Log)this.logger);
            client.setURI(new URI(this.gridEndpoint));
            HttpClientResponse resp = client.getJson("/status");
            if (resp.getStatusCode() > 200) {
                this.logger.error((Object)("Failed to get grid status: " + resp.getStatusLine()));
                return;
            }
            JsonObject value = (JsonObject)resp.getContent();
            client.close();
            JsonArray nodes = value.getAsJsonObject().get("value").getAsJsonObject().get("nodes").getAsJsonArray();
            for (JsonElement n : nodes) {
                JsonObject node = n.getAsJsonObject();
                activeSeleniumSessions = this.retrieveActiveSessionIds(node);
            }
            for (String key : driverSlots.keySet()) {
                Matcher matcher;
                if (!key.endsWith(".session") || !(matcher = this.slotRunPattern.matcher(key)).find()) continue;
                String slotName = matcher.group(1);
                if (driverSlots.keySet().contains("driver.slot." + slotName)) {
                    this.logger.info((Object)"Slot found for this session, moving on");
                    continue;
                }
                this.logger.info((Object)("Looking to discard the session " + (String)driverSlots.get(key) + ". Slot " + slotName + " no longer exists"));
                String sessionId = (String)driverSlots.get(key);
                if (activeSeleniumSessions.keySet().contains(sessionId)) {
                    client.setURI(new URI((String)activeSeleniumSessions.get(sessionId)));
                    client.addCommonHeader("X-REGISTRATION-SECRET", "");
                    HttpClientResponse delResp = client.deleteJson("/se/grid/node/session/" + (String)driverSlots.get(key));
                    if (delResp.getStatusCode() > 200) {
                        throw new SeleniumManagerException("Unable to delete session");
                    }
                    this.logger.info((Object)(sessionId + " has been removed from Grid"));
                } else {
                    this.logger.info((Object)"Selenium session has already expired on the the grid, no action required");
                }
                this.dss.performActions(new IDssAction[]{new DssDelete(key, (String)driverSlots.get(key))});
                this.logger.info((Object)(slotName + " has been cleaned up"));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Probelm running the selenium slot monitor", (Throwable)e);
        }
        this.logger.info((Object)"Stale slot search finished");
    }

    public Map<String, String> retrieveActiveSessionIds(JsonObject nodeJson) {
        HashMap<String, String> sessionIDs = new HashMap<String, String>();
        JsonArray slots = nodeJson.getAsJsonObject().get("slots").getAsJsonArray();
        for (JsonElement s : slots) {
            JsonObject slot = s.getAsJsonObject();
            JsonElement session = slot.get("session");
            if (slot.get("session") == null) continue;
            sessionIDs.put(session.getAsJsonObject().get("sessionId").getAsString(), nodeJson.get("uri").getAsString());
        }
        return sessionIDs;
    }

    public void removeGalasaStaleSessions(String uri, List<String> sessions) {
    }
}

