/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.selenium.internal;

import dev.galasa.ManagerException;
import dev.galasa.artifact.IArtifactManager;
import dev.galasa.docker.IDockerManager;
import dev.galasa.docker.spi.IDockerManagerSpi;
import dev.galasa.framework.spi.AbstractManager;
import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.GenerateAnnotatedField;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IManager;
import dev.galasa.framework.spi.ResourceUnavailableException;
import dev.galasa.framework.spi.Result;
import dev.galasa.framework.spi.language.GalasaMethod;
import dev.galasa.framework.spi.language.GalasaTest;
import dev.galasa.http.spi.IHttpManagerSpi;
import dev.galasa.kubernetes.spi.IKubernetesManagerSpi;
import dev.galasa.selenium.Browser;
import dev.galasa.selenium.ISeleniumManager;
import dev.galasa.selenium.IWebDriver;
import dev.galasa.selenium.SeleniumManager;
import dev.galasa.selenium.SeleniumManagerException;
import dev.galasa.selenium.SeleniumManagerField;
import dev.galasa.selenium.WebDriver;
import dev.galasa.selenium.internal.SeleniumEnvironment;
import dev.galasa.selenium.internal.properties.SeleniumPropertiesSingleton;
import dev.galasa.selenium.internal.properties.SeleniumScreenshotFailure;
import dev.galasa.selenium.internal.properties.SeleniumWebDriverType;
import dev.galasa.selenium.spi.ISeleniumManagerSpi;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;

@Component(service={IManager.class})
public class SeleniumManagerImpl
extends AbstractManager
implements ISeleniumManagerSpi {
    private static final Log logger = LogFactory.getLog(SeleniumManagerImpl.class);
    public static final String NAMESPACE = "selenium";
    private IConfigurationPropertyStoreService cps;
    private IDynamicStatusStoreService dss;
    private Path screenshotRasDirectory;
    private IFramework framework;
    private IDockerManagerSpi dockerManager;
    private IHttpManagerSpi httpManager;
    private IKubernetesManagerSpi k8Manager;
    private IArtifactManager artifactManager;
    private String currentMethod;
    private SeleniumEnvironment seleniumEnvironment;
    private boolean required = false;

    public void initialise(@NotNull IFramework framework, @NotNull List<IManager> allManagers, @NotNull List<IManager> activeManagers, @NotNull GalasaTest galasaTest) throws ManagerException {
        List ourFields;
        super.initialise(framework, allManagers, activeManagers, galasaTest);
        this.framework = framework;
        try {
            this.cps = framework.getConfigurationPropertyService(NAMESPACE);
            this.dss = framework.getDynamicStatusStoreService(NAMESPACE);
            SeleniumPropertiesSingleton.setCps(this.cps);
        }
        catch (Exception e) {
            throw new SeleniumManagerException("Unable to request framework services", e);
        }
        logger.info((Object)"Selenium manager has been succesfully initialised.");
        if (galasaTest.isJava().booleanValue() && (!(ourFields = this.findAnnotatedFields(SeleniumManagerField.class)).isEmpty() || this.required)) {
            this.youAreRequired(allManagers, activeManagers, galasaTest);
        }
    }

    public boolean areYouProvisionalDependentOn(@NotNull IManager otherManager) {
        if (otherManager instanceof IDockerManager) {
            return true;
        }
        if (otherManager instanceof IKubernetesManagerSpi) {
            return true;
        }
        return super.areYouProvisionalDependentOn(otherManager);
    }

    public void youAreRequired(@NotNull List<IManager> allManagers, @NotNull List<IManager> activeManagers, @NotNull GalasaTest galasaTest) throws ManagerException {
        this.required = true;
        if (activeManagers.contains(this)) {
            return;
        }
        try {
            switch (SeleniumWebDriverType.get()) {
                case "docker": {
                    this.dockerManager = (IDockerManagerSpi)this.addDependentManager(allManagers, activeManagers, galasaTest, IDockerManagerSpi.class);
                    if (this.dockerManager != null) break;
                    throw new SeleniumManagerException("Unable to locate the Docker Manager");
                }
                case "kubernetes": {
                    this.k8Manager = (IKubernetesManagerSpi)this.addDependentManager(allManagers, activeManagers, galasaTest, IKubernetesManagerSpi.class);
                    if (this.k8Manager != null) break;
                    throw new SeleniumManagerException("Unable to locate the Kubernetes Manager");
                }
            }
        }
        catch (ConfigurationPropertyStoreException e) {
            throw new SeleniumManagerException("Unable to determine selenium driver type");
        }
        activeManagers.add((IManager)this);
        this.httpManager = (IHttpManagerSpi)this.addDependentManager(allManagers, activeManagers, galasaTest, IHttpManagerSpi.class);
        if (this.httpManager == null) {
            throw new SeleniumManagerException("Unable to locate the Http Manager");
        }
        this.artifactManager = (IArtifactManager)this.addDependentManager(allManagers, activeManagers, galasaTest, IArtifactManager.class);
        if (this.artifactManager == null) {
            throw new SeleniumManagerException("Unable to locate the Artifact Manager");
        }
    }

    public void provisionGenerate() throws ManagerException, ResourceUnavailableException {
        Path storedArtifactsRoot = this.getFramework().getResultArchiveStore().getStoredArtifactsRoot();
        this.screenshotRasDirectory = storedArtifactsRoot.resolve(NAMESPACE).resolve("screenshots");
        this.seleniumEnvironment = new SeleniumEnvironment(this, this.screenshotRasDirectory);
        this.generateAnnotatedFields(SeleniumManagerField.class);
    }

    public void startOfTestMethod(@NotNull GalasaMethod galasaMethod) throws ManagerException {
        this.currentMethod = galasaMethod.getJavaExecutionMethod().getName();
    }

    public void provisionStop() {
        try {
            this.seleniumEnvironment.closePages();
        }
        catch (SeleniumManagerException e) {
            logger.error((Object)"Failed to discard pages", (Throwable)((Object)e));
        }
    }

    public void provisionDiscard() {
        try {
            this.seleniumEnvironment.discard();
        }
        catch (SeleniumManagerException e) {
            logger.error((Object)"Failed to discard seleniumEnvironment", (Throwable)((Object)e));
        }
    }

    @GenerateAnnotatedField(annotation=SeleniumManager.class)
    public ISeleniumManager generateSeleniumManager(Field field, List<Annotation> annotations) throws ResourceUnavailableException, SeleniumManagerException {
        SeleniumManager annoation = field.getAnnotation(SeleniumManager.class);
        Browser browser = annoation.browser();
        return this.seleniumEnvironment.allocateDriver(browser);
    }

    @GenerateAnnotatedField(annotation=WebDriver.class)
    public IWebDriver generateWebDriver(Field field, List<Annotation> annotations) throws ResourceUnavailableException, SeleniumManagerException {
        WebDriver annoation = field.getAnnotation(WebDriver.class);
        Browser browser = annoation.browser();
        return this.seleniumEnvironment.allocateWebDriver(browser);
    }

    public Result endOfTestMethod(@NotNull GalasaMethod galasaMethod, @NotNull Result currentResult, Throwable currentException) throws ManagerException {
        try {
            if (!currentResult.equals("Passed") && SeleniumScreenshotFailure.get().booleanValue()) {
                this.seleniumEnvironment.screenShotPages();
            }
        }
        catch (ConfigurationPropertyStoreException configurationPropertyStoreException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public IWebDriver provisionWebDriver(Browser browser) throws ResourceUnavailableException, SeleniumManagerException {
        return this.seleniumEnvironment.allocateWebDriver(browser);
    }

    public IFramework getFramework() {
        return this.framework;
    }

    public String getCurrentMethod() {
        return this.currentMethod;
    }

    public IConfigurationPropertyStoreService getCps() {
        return this.cps;
    }

    public IDynamicStatusStoreService getDss() {
        return this.dss;
    }

    public IDockerManagerSpi getDockerManager() {
        return this.dockerManager;
    }

    public IKubernetesManagerSpi getKubernetesManager() {
        return this.k8Manager;
    }

    public IArtifactManager getArtifactManager() {
        return this.artifactManager;
    }

    public IHttpManagerSpi getHttpManager() {
        return this.httpManager;
    }
}

