/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.selenium.internal;

import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IResourceManagement;
import dev.galasa.framework.spi.IResourceManagementProvider;
import dev.galasa.framework.spi.ResourceManagerException;
import dev.galasa.selenium.internal.SeleniumGridSessionMonitor;
import dev.galasa.selenium.internal.SeleniumSlotResourceMonitor;
import java.util.concurrent.TimeUnit;
import org.osgi.service.component.annotations.Component;

@Component(service={IResourceManagementProvider.class})
public class SeleniumResourceManagement
implements IResourceManagementProvider {
    private IFramework framework;
    private IResourceManagement resourceManagement;
    private IDynamicStatusStoreService dss;
    private IConfigurationPropertyStoreService cps;
    private SeleniumSlotResourceMonitor slotMonitor;
    private SeleniumGridSessionMonitor gridSessionMonitor;

    public boolean initialise(IFramework framework, IResourceManagement resourceManagement) throws ResourceManagerException {
        this.framework = framework;
        this.resourceManagement = resourceManagement;
        try {
            this.cps = framework.getConfigurationPropertyService("selenium");
            this.dss = framework.getDynamicStatusStoreService("selenium");
        }
        catch (DynamicStatusStoreException e) {
            throw new ResourceManagerException("Could not initialise docker resource monitor, due to the CPS:  ", (Throwable)e);
        }
        catch (ConfigurationPropertyStoreException e) {
            throw new ResourceManagerException("Could not initialise docker resource monitor, due to the DSS:  ", (Throwable)e);
        }
        this.slotMonitor = new SeleniumSlotResourceMonitor(framework, resourceManagement, this.dss, this.cps);
        this.gridSessionMonitor = new SeleniumGridSessionMonitor(framework, resourceManagement, this.dss, this.cps);
        return true;
    }

    public void start() {
        this.resourceManagement.getScheduledExecutorService().scheduleWithFixedDelay(this.slotMonitor, this.framework.getRandom().nextInt(20), 20L, TimeUnit.SECONDS);
        this.resourceManagement.getScheduledExecutorService().scheduleWithFixedDelay(this.gridSessionMonitor, this.framework.getRandom().nextInt(20), 20L, TimeUnit.SECONDS);
    }

    public void shutdown() {
    }

    public void runFinishedOrDeleted(String runName) {
    }
}

