/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.selenium.internal;

import dev.galasa.framework.spi.DssDelete;
import dev.galasa.framework.spi.DssSwap;
import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IDssAction;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IResourceManagement;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SeleniumSlotResourceMonitor
implements Runnable {
    private final IFramework framework;
    private final IResourceManagement resourceManagement;
    private final IDynamicStatusStoreService dss;
    private final IConfigurationPropertyStoreService cps;
    private final Log logger = LogFactory.getLog(SeleniumSlotResourceMonitor.class);
    private final Pattern slotRunPattern = Pattern.compile("^driver\\.slot\\.(\\w+)");

    public SeleniumSlotResourceMonitor(IFramework framework, IResourceManagement resourceManagement, IDynamicStatusStoreService dss, IConfigurationPropertyStoreService cps) {
        this.framework = framework;
        this.dss = dss;
        this.cps = cps;
        this.resourceManagement = resourceManagement;
        this.logger.info((Object)"Selenium slot resource monitor intialised");
    }

    @Override
    public void run() {
        this.logger.info((Object)"Starting search for run slots.");
        this.checkForStaleSlots();
        this.logger.info((Object)"Finished search for run slots.");
    }

    public void checkForStaleSlots() {
        try {
            Map driverSlots = this.dss.getPrefix("driver.slot");
            Set activeRunNames = this.framework.getFrameworkRuns().getActiveRunNames();
            for (String key : driverSlots.keySet()) {
                if (key.endsWith(".session")) continue;
                String runName = (String)driverSlots.get(key);
                if (activeRunNames.contains(runName)) {
                    this.logger.info((Object)"Run still active, continuing");
                    continue;
                }
                Matcher matcher = this.slotRunPattern.matcher(key);
                if (!matcher.find()) continue;
                String slotName = matcher.group(0);
                this.logger.info((Object)("Stale slot found: " + slotName));
                try {
                    this.logger.info((Object)("Discarding slot " + slotName + " as the run " + runName + " no longer exists"));
                    int currentSlots = Integer.valueOf(this.dss.get("driver.current.slots"));
                    this.dss.performActions(new IDssAction[]{new DssDelete(key, runName), new DssSwap("driver.current.slots", String.valueOf(currentSlots), String.valueOf(currentSlots - 1))});
                }
                catch (DynamicStatusStoreException e) {
                    this.logger.error((Object)("Failed to clean slot:" + slotName));
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Probelm running the selenium slot monitor");
        }
        this.logger.info((Object)"Stale slot search finished");
    }
}

