/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.selenium.internal;

import dev.galasa.ResultArchiveStoreContentType;
import dev.galasa.SetContentType;
import dev.galasa.selenium.IWebPage;
import dev.galasa.selenium.SeleniumManagerException;
import dev.galasa.selenium.internal.SeleniumManagerImpl;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPageImpl
implements IWebPage {
    private SeleniumManagerImpl selMan;
    private WebDriver driver;
    private List<IWebPage> webPages;
    private Path screenshotRasDirectory;
    public static final int DEFAULT_SECONDS_TIMEOUT = 30;

    public WebPageImpl(SeleniumManagerImpl selMan, WebDriver driver, List<IWebPage> webPages, Path screenshotRasDirectory) {
        this.selMan = selMan;
        this.driver = driver;
        this.webPages = webPages;
        this.screenshotRasDirectory = screenshotRasDirectory;
    }

    @Override
    public void close() {
        this.driver.close();
    }

    @Override
    public IWebPage clearElementByClassName(String className) {
        return this.clearElement(By.className(className), 30);
    }

    @Override
    public IWebPage clearElementByClassName(String className, int secondsTimeout) {
        return this.clearElement(By.className(className), secondsTimeout);
    }

    @Override
    public IWebPage clearElementByCssSelector(String selector) {
        return this.clearElement(By.cssSelector(selector), 30);
    }

    @Override
    public IWebPage clearElementByCssSelector(String selector, int secondsTimeout) {
        return this.clearElement(By.cssSelector(selector), secondsTimeout);
    }

    @Override
    public IWebPage clearElementById(String id) {
        return this.clearElement(By.id(id), 30);
    }

    @Override
    public IWebPage clearElementById(String id, int secondsTimeout) {
        return this.clearElement(By.id(id), secondsTimeout);
    }

    @Override
    public IWebPage clearElementByLinkText(String linkText) {
        return this.clearElement(By.linkText(linkText), 30);
    }

    @Override
    public IWebPage clearElementByLinkText(String linkText, int secondsTimeout) {
        return this.clearElement(By.linkText(linkText), secondsTimeout);
    }

    @Override
    public IWebPage clearElementByName(String name) {
        return this.clearElement(By.name(name), 30);
    }

    @Override
    public IWebPage clearElementByName(String name, int secondsTimeout) {
        return this.clearElement(By.name(name), secondsTimeout);
    }

    @Override
    public IWebPage clearElementByPartialLinkText(String linkText) {
        return this.clearElement(By.partialLinkText(linkText), 30);
    }

    @Override
    public IWebPage clearElementByPartialLinkText(String linkText, int secondsTimeout) {
        return this.clearElement(By.partialLinkText(linkText), secondsTimeout);
    }

    @Override
    public IWebPage clearElementByTagName(String name) {
        return this.clearElement(By.tagName(name), 30);
    }

    @Override
    public IWebPage clearElementByTagName(String name, int secondsTimeout) {
        return this.clearElement(By.tagName(name), secondsTimeout);
    }

    @Override
    public IWebPage clearElementByXpath(String xpathExpression) {
        return this.clearElement(By.xpath(xpathExpression), 30);
    }

    @Override
    public IWebPage clearElementByXpath(String xpathExpression, int secondsTimeout) {
        return this.clearElement(By.xpath(xpathExpression), secondsTimeout);
    }

    @Override
    public IWebPage clearElement(By by) {
        return this.clearElement(by, 30);
    }

    @Override
    public IWebPage clearElement(By by, int secondsTimeout) {
        this.waitForElement(by, secondsTimeout).clear();
        return this;
    }

    @Override
    public IWebPage clickElementByClassName(String className) {
        return this.clickElement(By.className(className), 30);
    }

    @Override
    public IWebPage clickElementByClassName(String className, int secondsTimeout) {
        return this.clickElement(By.className(className), secondsTimeout);
    }

    @Override
    public IWebPage clickElementByCssSelector(String selector) {
        return this.clickElement(By.cssSelector(selector), 30);
    }

    @Override
    public IWebPage clickElementByCssSelector(String selector, int secondsTimeout) {
        return this.clickElement(By.cssSelector(selector), secondsTimeout);
    }

    @Override
    public IWebPage clickElementById(String id) {
        return this.clickElement(By.id(id), 30);
    }

    @Override
    public IWebPage clickElementById(String id, int secondsTimeout) {
        return this.clickElement(By.id(id), secondsTimeout);
    }

    @Override
    public IWebPage clickElementByLinkText(String linkText) {
        return this.clickElement(By.linkText(linkText), 30);
    }

    @Override
    public IWebPage clickElementByLinkText(String linkText, int secondsTimeout) {
        return this.clickElement(By.linkText(linkText), secondsTimeout);
    }

    @Override
    public IWebPage clickElementByName(String name) {
        return this.clickElement(By.name(name), 30);
    }

    @Override
    public IWebPage clickElementByName(String name, int secondsTimeout) {
        return this.clickElement(By.name(name), secondsTimeout);
    }

    @Override
    public IWebPage clickElementByPartialLinkText(String linkText) {
        return this.clickElement(By.partialLinkText(linkText), 30);
    }

    @Override
    public IWebPage clickElementByPartialLinkText(String linkText, int secondsTimeout) {
        return this.clickElement(By.partialLinkText(linkText), secondsTimeout);
    }

    @Override
    public IWebPage clickElementByTagName(String name) {
        return this.clickElement(By.tagName(name), 30);
    }

    @Override
    public IWebPage clickElementByTagName(String name, int secondsTimeout) {
        return this.clickElement(By.tagName(name), secondsTimeout);
    }

    @Override
    public IWebPage clickElementByXpath(String xpathExpression) {
        return this.clickElement(By.xpath(xpathExpression), 30);
    }

    @Override
    public IWebPage clickElementByXpath(String xpathExpression, int secondsTimeout) {
        return this.clickElement(By.xpath(xpathExpression), secondsTimeout);
    }

    @Override
    public IWebPage clickElement(By by) {
        return this.clickElement(by, 30);
    }

    @Override
    public IWebPage clickElement(By by, int secondsTimeout) {
        this.waitForElement(by, secondsTimeout).click();
        return this;
    }

    @Override
    public IWebPage sendKeysToElementByClassName(String className, CharSequence keysToSend) {
        return this.sendKeysToElement(By.className(className), keysToSend, 30);
    }

    @Override
    public IWebPage sendKeysToElementByClassName(String className, CharSequence keysToSend, int secondsTimeout) {
        return this.sendKeysToElement(By.className(className), keysToSend, secondsTimeout);
    }

    @Override
    public IWebPage sendKeysToElementByCssSelector(String selector, CharSequence keysToSend) {
        return this.sendKeysToElement(By.cssSelector(selector), keysToSend, 30);
    }

    @Override
    public IWebPage sendKeysToElementByCssSelector(String selector, CharSequence keysToSend, int secondsTimeout) {
        return this.sendKeysToElement(By.cssSelector(selector), keysToSend, secondsTimeout);
    }

    @Override
    public IWebPage sendKeysToElementById(String id, CharSequence keysToSend) {
        return this.sendKeysToElement(By.id(id), keysToSend, 30);
    }

    @Override
    public IWebPage sendKeysToElementById(String id, CharSequence keysToSend, int secondsTimeout) {
        return this.sendKeysToElement(By.id(id), keysToSend, secondsTimeout);
    }

    @Override
    public IWebPage sendKeysToElementByLinkText(String linkText, CharSequence keysToSend) {
        return this.sendKeysToElement(By.linkText(linkText), keysToSend, 30);
    }

    @Override
    public IWebPage sendKeysToElementByLinkText(String linkText, CharSequence keysToSend, int secondsTimeout) {
        return this.sendKeysToElement(By.linkText(linkText), keysToSend, secondsTimeout);
    }

    @Override
    public IWebPage sendKeysToElementByName(String name, CharSequence keysToSend) {
        return this.sendKeysToElement(By.name(name), keysToSend, 30);
    }

    @Override
    public IWebPage sendKeysToElementByName(String name, CharSequence keysToSend, int secondsTimeout) {
        return this.sendKeysToElement(By.name(name), keysToSend, secondsTimeout);
    }

    @Override
    public IWebPage sendKeysToElementByPartialLinkText(String linkText, CharSequence keysToSend) {
        return this.sendKeysToElement(By.partialLinkText(linkText), keysToSend, 30);
    }

    @Override
    public IWebPage sendKeysToElementByPartialLinkText(String linkText, CharSequence keysToSend, int secondsTimeout) {
        return this.sendKeysToElement(By.partialLinkText(linkText), keysToSend, secondsTimeout);
    }

    @Override
    public IWebPage sendKeysToElementByTagName(String name, CharSequence keysToSend) {
        return this.sendKeysToElement(By.tagName(name), keysToSend, 30);
    }

    @Override
    public IWebPage sendKeysToElementByTagName(String name, CharSequence keysToSend, int secondsTimeout) {
        return this.sendKeysToElement(By.tagName(name), keysToSend, secondsTimeout);
    }

    @Override
    public IWebPage sendKeysToElementByXpath(String xpathExpression, CharSequence keysToSend) {
        return this.sendKeysToElement(By.xpath(xpathExpression), keysToSend, 30);
    }

    @Override
    public IWebPage sendKeysToElementByXpath(String xpathExpression, CharSequence keysToSend, int secondsTimeout) {
        return this.sendKeysToElement(By.xpath(xpathExpression), keysToSend, secondsTimeout);
    }

    @Override
    public IWebPage sendKeysToElement(By by, CharSequence keysToSend) {
        return this.sendKeysToElement(by, keysToSend, 30);
    }

    @Override
    public IWebPage sendKeysToElement(By by, CharSequence keysToSend, int secondsTimeout) {
        this.waitForElement(by, secondsTimeout).sendKeys(keysToSend);
        return this;
    }

    @Override
    public WebElement findElementByClassName(String className) {
        return this.findElement(By.className(className));
    }

    @Override
    public List<WebElement> findElementsByClassName(String className) {
        return this.findElements(By.className(className));
    }

    @Override
    public WebElement findElementByCssSelector(String selector) {
        return this.findElement(By.cssSelector(selector));
    }

    @Override
    public List<WebElement> findElementsByCssSelector(String selector) {
        return this.findElements(By.cssSelector(selector));
    }

    @Override
    public WebElement findElementById(String id) {
        return this.findElement(By.id(id));
    }

    @Override
    public List<WebElement> findElementsById(String id) {
        return this.findElements(By.id(id));
    }

    @Override
    public WebElement findElementByLinkText(String linkText) {
        return this.findElement(By.linkText(linkText));
    }

    @Override
    public List<WebElement> findElementsByLinkText(String linkText) {
        return this.findElements(By.linkText(linkText));
    }

    @Override
    public WebElement findElementByName(String name) {
        return this.findElement(By.name(name));
    }

    @Override
    public List<WebElement> findElementsByName(String name) {
        return this.findElements(By.name(name));
    }

    @Override
    public WebElement findElementByPartialLinkText(String linkText) {
        return this.findElement(By.partialLinkText(linkText));
    }

    @Override
    public List<WebElement> findElementsByPartialLinkText(String linkText) {
        return this.findElements(By.partialLinkText(linkText));
    }

    @Override
    public WebElement findElementByTagName(String name) {
        return this.findElement(By.tagName(name));
    }

    @Override
    public List<WebElement> findElementsByTagName(String name) {
        return this.findElements(By.tagName(name));
    }

    @Override
    public WebElement findElementByXpath(String xpathExpression) {
        return this.findElement(By.xpath(xpathExpression));
    }

    @Override
    public List<WebElement> findElementsByXpath(String xpathExpression) {
        return this.findElements(By.xpath(xpathExpression));
    }

    @Override
    public WebElement findElement(By by) {
        WebDriverWait wait = new WebDriverWait(this.driver, 30L);
        wait.until(ExpectedConditions.presenceOfElementLocated(by));
        return this.driver.findElement(by);
    }

    @Override
    public List<WebElement> findElements(By by) {
        WebDriverWait wait = new WebDriverWait(this.driver, 30L);
        wait.until(ExpectedConditions.presenceOfElementLocated(by));
        return this.driver.findElements(by);
    }

    @Override
    public IWebPage get(String url) {
        this.driver.get(url);
        return this;
    }

    @Override
    public String getCurrentUrl() {
        return this.driver.getCurrentUrl();
    }

    @Override
    public String getPageSource() {
        return this.driver.getPageSource();
    }

    @Override
    public String getTitle() {
        return this.driver.getTitle();
    }

    @Override
    public String getWindowHandle() {
        return this.driver.getWindowHandle();
    }

    @Override
    public Set<String> getWindowHandles() {
        return this.driver.getWindowHandles();
    }

    @Override
    public WebDriver.Options manage() {
        return this.driver.manage();
    }

    @Override
    public WebDriver.Navigation navigate() {
        return this.driver.navigate();
    }

    @Override
    public void quit() {
        this.webPages.remove(this);
        this.driver.quit();
    }

    public void managerQuit() {
        this.driver.quit();
    }

    @Override
    public WebDriver.TargetLocator switchTo() {
        return this.driver.switchTo();
    }

    @Override
    public IWebPage switchToFrameByClassName(String className) {
        return this.switchToFrame(By.className(className));
    }

    @Override
    public IWebPage switchToFrameByCssSelector(String selector) {
        return this.switchToFrame(By.cssSelector(selector));
    }

    @Override
    public IWebPage switchToFrameById(String id) {
        return this.switchToFrame(By.id(id));
    }

    @Override
    public IWebPage switchToFrameByLinkText(String linkText) {
        return this.switchToFrame(By.linkText(linkText));
    }

    @Override
    public IWebPage switchToFrameByName(String name) {
        return this.switchToFrame(By.name(name));
    }

    @Override
    public IWebPage switchToFrameByPartialLinkText(String linkText) {
        return this.switchToFrame(By.partialLinkText(linkText));
    }

    @Override
    public IWebPage switchToFrameByTagName(String name) {
        return this.switchToFrame(By.tagName(name));
    }

    @Override
    public IWebPage switchToFrameByXpath(String xpathExpression) {
        return this.switchToFrame(By.xpath(xpathExpression));
    }

    @Override
    public IWebPage switchToFrame(By by) {
        this.switchTo().frame(this.findElement(by));
        return this;
    }

    @Override
    public WebElement waitForElementByClassName(String className) {
        return this.waitForElement(By.className(className), 30);
    }

    @Override
    public WebElement waitForElementByClassName(String className, int secondsTimeout) {
        return this.waitForElement(By.className(className), secondsTimeout);
    }

    @Override
    public WebElement waitForElementByCssSelector(String selector) {
        return this.waitForElement(By.cssSelector(selector), 30);
    }

    @Override
    public WebElement waitForElementByCssSelector(String selector, int secondsTimeout) {
        return this.waitForElement(By.cssSelector(selector), secondsTimeout);
    }

    @Override
    public WebElement waitForElementById(String id) {
        return this.waitForElement(By.id(id), 30);
    }

    @Override
    public WebElement waitForElementById(String id, int secondsTimeout) {
        return this.waitForElement(By.id(id), secondsTimeout);
    }

    @Override
    public WebElement waitForElementByLinkText(String linkText) {
        return this.waitForElement(By.linkText(linkText), 30);
    }

    @Override
    public WebElement waitForElementByLinkText(String linkText, int secondsTimeout) {
        return this.waitForElement(By.linkText(linkText), secondsTimeout);
    }

    @Override
    public WebElement waitForElementByName(String name) {
        return this.waitForElement(By.name(name), 30);
    }

    @Override
    public WebElement waitForElementByName(String name, int secondsTimeout) {
        return this.waitForElement(By.tagName(name), secondsTimeout);
    }

    @Override
    public WebElement waitForElementByPartialLinkText(String linkText) {
        return this.waitForElement(By.partialLinkText(linkText), 30);
    }

    @Override
    public WebElement waitForElementByPartialLinkText(String linkText, int secondsTimeout) {
        return this.waitForElement(By.partialLinkText(linkText), secondsTimeout);
    }

    @Override
    public WebElement waitForElementByTagName(String tagName) {
        return this.waitForElement(By.tagName(tagName), 30);
    }

    @Override
    public WebElement waitForElementByTagName(String tagName, int secondsTimeout) {
        return this.waitForElement(By.tagName(tagName), secondsTimeout);
    }

    @Override
    public WebElement waitForElementByXpath(String xpathExpression) {
        return this.waitForElement(By.xpath(xpathExpression), 30);
    }

    @Override
    public WebElement waitForElementByXpath(String xpathExpression, int secondsTimeout) {
        return this.waitForElement(By.xpath(xpathExpression), secondsTimeout);
    }

    @Override
    public WebElement waitForElement(By by) {
        return this.waitForElement(by, 30);
    }

    @Override
    public WebElement waitForElement(By by, int secondsTimeout) {
        WebDriverWait wait = new WebDriverWait(this.driver, secondsTimeout);
        wait.until(ExpectedConditions.presenceOfElementLocated(by));
        return this.findElement(by);
    }

    @Override
    public WebDriverWait driverWait() {
        return this.driverWait(30);
    }

    @Override
    public WebDriverWait driverWait(int secondsTimeout) {
        return new WebDriverWait(this.driver, secondsTimeout);
    }

    @Override
    public WebDriver getWebDriver() {
        return this.driver;
    }

    @Override
    public IWebPage maximize() {
        this.manage().window().maximize();
        return this;
    }

    @Override
    public IWebPage waitForPageLoad() {
        return this.waitForPageLoad(30);
    }

    @Override
    public IWebPage waitForPageLoad(int secondsTimeout) {
        WebDriverWait wait = new WebDriverWait(this.driver, secondsTimeout);
        wait.until(webDriver -> String.valueOf("complete".equals(((JavascriptExecutor)((Object)webDriver)).executeScript("return document.readyState", new Object[0]))));
        return this;
    }

    @Override
    public IWebPage takeScreenShot() throws SeleniumManagerException {
        File scrFile = ((TakesScreenshot)((Object)this.driver)).getScreenshotAs(OutputType.FILE);
        String time = String.valueOf(Instant.now().toEpochMilli());
        try {
            Files.createFile(this.screenshotRasDirectory.resolve(this.selMan.getCurrentMethod()).resolve("screenshot_" + time + ".png"), new FileAttribute[0]);
            try (OutputStream os = Files.newOutputStream(this.screenshotRasDirectory.resolve(this.selMan.getCurrentMethod()).resolve("screenshot_" + time + ".png"), new OpenOption[]{new SetContentType(ResultArchiveStoreContentType.PNG)});){
                Files.copy(scrFile.toPath(), os);
                os.flush();
                os.close();
            }
        }
        catch (IOException e) {
            throw new SeleniumManagerException("Unable to take screenshot", e);
        }
        return this;
    }
}

