/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.Serializable;
import java.util.List;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;

public abstract class By {
    public static By id(String id) {
        return new ById(id);
    }

    public static By linkText(String linkText) {
        return new ByLinkText(linkText);
    }

    public static By partialLinkText(String partialLinkText) {
        return new ByPartialLinkText(partialLinkText);
    }

    public static By name(String name) {
        return new ByName(name);
    }

    public static By tagName(String tagName) {
        return new ByTagName(tagName);
    }

    public static By xpath(String xpathExpression) {
        return new ByXPath(xpathExpression);
    }

    public static By className(String className) {
        return new ByClassName(className);
    }

    public static By cssSelector(String cssSelector) {
        return new ByCssSelector(cssSelector);
    }

    public WebElement findElement(SearchContext context) {
        List<WebElement> allElements = this.findElements(context);
        if (allElements == null || allElements.isEmpty()) {
            throw new NoSuchElementException("Cannot locate an element using " + this.toString());
        }
        return allElements.get(0);
    }

    public abstract List<WebElement> findElements(SearchContext var1);

    public boolean equals(Object o) {
        if (!(o instanceof By)) {
            return false;
        }
        By that = (By)o;
        return this.toString().equals(that.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "[unknown locator]";
    }

    public static class ByCssSelector
    extends By
    implements Serializable {
        private static final long serialVersionUID = -3910258723099459239L;
        private final String cssSelector;

        public ByCssSelector(String cssSelector) {
            if (cssSelector == null) {
                throw new IllegalArgumentException("Cannot find elements when the selector is null");
            }
            this.cssSelector = cssSelector;
        }

        @Override
        public WebElement findElement(SearchContext context) {
            if (context instanceof FindsByCssSelector) {
                return ((FindsByCssSelector)context).findElementByCssSelector(this.cssSelector);
            }
            throw new WebDriverException("Driver does not support finding an element by selector: " + this.cssSelector);
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            if (context instanceof FindsByCssSelector) {
                return ((FindsByCssSelector)context).findElementsByCssSelector(this.cssSelector);
            }
            throw new WebDriverException("Driver does not support finding elements by selector: " + this.cssSelector);
        }

        @Override
        public String toString() {
            return "By.cssSelector: " + this.cssSelector;
        }
    }

    public static class ByClassName
    extends By
    implements Serializable {
        private static final long serialVersionUID = -8737882849130394673L;
        private final String className;

        public ByClassName(String className) {
            if (className == null) {
                throw new IllegalArgumentException("Cannot find elements when the class name expression is null.");
            }
            this.className = className;
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            if (context instanceof FindsByClassName) {
                return ((FindsByClassName)context).findElementsByClassName(this.className);
            }
            return ((FindsByXPath)context).findElementsByXPath(".//*[" + this.containingWord("class", this.className) + "]");
        }

        @Override
        public WebElement findElement(SearchContext context) {
            if (context instanceof FindsByClassName) {
                return ((FindsByClassName)context).findElementByClassName(this.className);
            }
            return ((FindsByXPath)context).findElementByXPath(".//*[" + this.containingWord("class", this.className) + "]");
        }

        private String containingWord(String attribute, String word) {
            return "contains(concat(' ',normalize-space(@" + attribute + "),' '),' " + word + " ')";
        }

        @Override
        public String toString() {
            return "By.className: " + this.className;
        }
    }

    public static class ByXPath
    extends By
    implements Serializable {
        private static final long serialVersionUID = -6727228887685051584L;
        private final String xpathExpression;

        public ByXPath(String xpathExpression) {
            if (xpathExpression == null) {
                throw new IllegalArgumentException("Cannot find elements when the XPath is null.");
            }
            this.xpathExpression = xpathExpression;
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            return ((FindsByXPath)context).findElementsByXPath(this.xpathExpression);
        }

        @Override
        public WebElement findElement(SearchContext context) {
            return ((FindsByXPath)context).findElementByXPath(this.xpathExpression);
        }

        @Override
        public String toString() {
            return "By.xpath: " + this.xpathExpression;
        }
    }

    public static class ByTagName
    extends By
    implements Serializable {
        private static final long serialVersionUID = 4699295846984948351L;
        private final String tagName;

        public ByTagName(String tagName) {
            if (tagName == null) {
                throw new IllegalArgumentException("Cannot find elements when the tag name is null.");
            }
            this.tagName = tagName;
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            if (context instanceof FindsByTagName) {
                return ((FindsByTagName)context).findElementsByTagName(this.tagName);
            }
            return ((FindsByXPath)context).findElementsByXPath(".//" + this.tagName);
        }

        @Override
        public WebElement findElement(SearchContext context) {
            if (context instanceof FindsByTagName) {
                return ((FindsByTagName)context).findElementByTagName(this.tagName);
            }
            return ((FindsByXPath)context).findElementByXPath(".//" + this.tagName);
        }

        @Override
        public String toString() {
            return "By.tagName: " + this.tagName;
        }
    }

    public static class ByName
    extends By
    implements Serializable {
        private static final long serialVersionUID = 376317282960469555L;
        private final String name;

        public ByName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Cannot find elements when name text is null.");
            }
            this.name = name;
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            if (context instanceof FindsByName) {
                return ((FindsByName)context).findElementsByName(this.name);
            }
            return ((FindsByXPath)context).findElementsByXPath(".//*[@name = '" + this.name + "']");
        }

        @Override
        public WebElement findElement(SearchContext context) {
            if (context instanceof FindsByName) {
                return ((FindsByName)context).findElementByName(this.name);
            }
            return ((FindsByXPath)context).findElementByXPath(".//*[@name = '" + this.name + "']");
        }

        @Override
        public String toString() {
            return "By.name: " + this.name;
        }
    }

    public static class ByPartialLinkText
    extends By
    implements Serializable {
        private static final long serialVersionUID = 1163955344140679054L;
        private final String partialLinkText;

        public ByPartialLinkText(String partialLinkText) {
            if (partialLinkText == null) {
                throw new IllegalArgumentException("Cannot find elements when the link text is null.");
            }
            this.partialLinkText = partialLinkText;
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            return ((FindsByLinkText)context).findElementsByPartialLinkText(this.partialLinkText);
        }

        @Override
        public WebElement findElement(SearchContext context) {
            return ((FindsByLinkText)context).findElementByPartialLinkText(this.partialLinkText);
        }

        @Override
        public String toString() {
            return "By.partialLinkText: " + this.partialLinkText;
        }
    }

    public static class ByLinkText
    extends By
    implements Serializable {
        private static final long serialVersionUID = 1967414585359739708L;
        private final String linkText;

        public ByLinkText(String linkText) {
            if (linkText == null) {
                throw new IllegalArgumentException("Cannot find elements when the link text is null.");
            }
            this.linkText = linkText;
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            return ((FindsByLinkText)context).findElementsByLinkText(this.linkText);
        }

        @Override
        public WebElement findElement(SearchContext context) {
            return ((FindsByLinkText)context).findElementByLinkText(this.linkText);
        }

        @Override
        public String toString() {
            return "By.linkText: " + this.linkText;
        }
    }

    public static class ById
    extends By
    implements Serializable {
        private static final long serialVersionUID = 5341968046120372169L;
        private final String id;

        public ById(String id) {
            if (id == null) {
                throw new IllegalArgumentException("Cannot find elements when the id is null.");
            }
            this.id = id;
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            if (context instanceof FindsById) {
                return ((FindsById)context).findElementsById(this.id);
            }
            return ((FindsByXPath)context).findElementsByXPath(".//*[@id = '" + this.id + "']");
        }

        @Override
        public WebElement findElement(SearchContext context) {
            if (context instanceof FindsById) {
                return ((FindsById)context).findElementById(this.id);
            }
            return ((FindsByXPath)context).findElementByXPath(".//*[@id = '" + this.id + "']");
        }

        @Override
        public String toString() {
            return "By.id: " + this.id;
        }
    }
}

