/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.AddRotatable;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.html5.AddApplicationCache;
import org.openqa.selenium.remote.html5.AddLocationContext;
import org.openqa.selenium.remote.html5.AddWebStorage;
import org.openqa.selenium.remote.mobile.AddNetworkConnection;

public abstract class BaseAugmenter {
    private final Map<String, AugmenterProvider> driverAugmentors = new HashMap<String, AugmenterProvider>();
    private final Map<String, AugmenterProvider> elementAugmentors = new HashMap<String, AugmenterProvider>();

    public BaseAugmenter() {
        this.addDriverAugmentation("locationContextEnabled", (AugmenterProvider)new AddLocationContext());
        this.addDriverAugmentation("applicationCacheEnabled", (AugmenterProvider)new AddApplicationCache());
        this.addDriverAugmentation("networkConnectionEnabled", (AugmenterProvider)new AddNetworkConnection());
        this.addDriverAugmentation("webStorageEnabled", (AugmenterProvider)new AddWebStorage());
        this.addDriverAugmentation("rotatable", new AddRotatable());
    }

    public void addDriverAugmentation(String capabilityName, AugmenterProvider handlerClass) {
        this.driverAugmentors.put(capabilityName, handlerClass);
    }

    public void addElementAugmentation(String capabilityName, AugmenterProvider handlerClass) {
        this.elementAugmentors.put(capabilityName, handlerClass);
    }

    public WebDriver augment(WebDriver driver) {
        RemoteWebDriver remoteDriver = this.extractRemoteWebDriver(driver);
        if (remoteDriver == null) {
            return driver;
        }
        return this.create(remoteDriver, this.driverAugmentors, driver);
    }

    public WebElement augment(RemoteWebElement element) {
        RemoteWebDriver parent = (RemoteWebDriver)element.getWrappedDriver();
        if (parent == null) {
            return element;
        }
        return this.create(parent, this.elementAugmentors, element);
    }

    protected abstract <X> X create(RemoteWebDriver var1, Map<String, AugmenterProvider> var2, X var3);

    protected abstract RemoteWebDriver extractRemoteWebDriver(WebDriver var1);
}

