/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.gemfire.testcontainers;

import com.vmware.gemfire.testcontainers.AbstractGemFireContainer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.images.builder.Transferable;

public class Gfsh {
    private static final Logger logger = LoggerFactory.getLogger((String)"gfsh");
    private final AbstractGemFireContainer<?> locator;
    private final String connectCommand;
    private final boolean logOutput;

    private Gfsh(AbstractGemFireContainer<?> locator, String connectCommand, boolean logOutput) {
        this.locator = locator;
        this.connectCommand = connectCommand;
        this.logOutput = logOutput;
    }

    public String run(String ... commands) {
        return this.run(Arrays.asList(commands));
    }

    public String run(List<String> commands) {
        Container.ExecResult result;
        ArrayList<String> tmpCommands = new ArrayList<String>();
        tmpCommands.add(this.connectCommand);
        tmpCommands.addAll(commands);
        String commandFileContents = String.join((CharSequence)"\n", tmpCommands);
        this.locator.copyFileToContainer(Transferable.of((String)commandFileContents, (int)438), "/script.gfsh");
        try {
            boolean scriptError;
            result = this.locator.execInContainer(new String[]{"gfsh", "-e", "run --file=/script.gfsh"});
            boolean bl = scriptError = result.getExitCode() != 0;
            if (this.logOutput || scriptError) {
                for (String line : result.toString().split("\n")) {
                    if (scriptError) {
                        logger.error(line);
                        continue;
                    }
                    logger.info(line);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error executing gfsh command: " + Arrays.asList(commands), ex);
        }
        if (result.getExitCode() != 0) {
            throw new RuntimeException("Error executing gfsh command. Return code: " + result.getExitCode());
        }
        return result.toString();
    }

    public static class Builder {
        final AbstractGemFireContainer<?> locator;
        private boolean withLogging;
        private Map<String, String> gfshOptions = new HashMap<String, String>();

        Builder(AbstractGemFireContainer<?> locator) {
            this.locator = locator;
        }

        public Builder withCredentials(String username, String password) {
            this.gfshOptions.put("--username", username);
            this.gfshOptions.put("--password", password);
            return this;
        }

        public Builder withKeyStore(String keyStoreFile, String keyStorePassword) throws IOException {
            byte[] content = Files.readAllBytes(Paths.get(keyStoreFile, new String[0]));
            return this.withKeyStore(content, keyStorePassword);
        }

        public Builder withKeyStore(byte[] keyStoreBytes, String keyStorePassword) {
            String filename = "/key-store";
            this.gfshOptions.put("--key-store", filename);
            this.gfshOptions.put("--key-store-password", keyStorePassword);
            this.locator.copyFileToContainer(Transferable.of((byte[])keyStoreBytes, (int)438), filename);
            return this;
        }

        public Builder withTrustStore(String trustStoreFile, String trustStorePassword) throws IOException {
            byte[] content = Files.readAllBytes(Paths.get(trustStoreFile, new String[0]));
            return this.withTrustStore(content, trustStorePassword);
        }

        public Builder withTrustStore(byte[] trustStoreBytes, String trustStorePassword) {
            String filename = "/trust-store";
            this.gfshOptions.put("--trust-store", filename);
            this.gfshOptions.put("--trust-store-password", trustStorePassword);
            this.locator.copyFileToContainer(Transferable.of((byte[])trustStoreBytes, (int)438), filename);
            return this;
        }

        public Builder withCiphers(String ciphers) {
            this.gfshOptions.put("--ciphers", ciphers);
            return this;
        }

        public Builder withProtocols(String protocols) {
            this.gfshOptions.put("--protocols", protocols);
            return this;
        }

        public Builder withToken(String token) {
            this.gfshOptions.put("--token", token);
            return this;
        }

        public Builder withLogging(boolean withLogging) {
            this.withLogging = withLogging;
            return this;
        }

        public Builder withSecurityProperties(String securityFile) throws IOException {
            byte[] content = Files.readAllBytes(Paths.get(securityFile, new String[0]));
            this.writeSecurityPropertiesFile(content);
            return this;
        }

        public Builder withSecurityProperties(Properties securityProperties) throws IOException {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                securityProperties.store(baos, "Security Properties");
                this.writeSecurityPropertiesFile(baos.toByteArray());
            }
            return this;
        }

        private void writeSecurityPropertiesFile(byte[] fileBytes) {
            String filename = "/security.properties";
            ArrayList<String> options = new ArrayList<String>();
            options.add("--security-properties-file=");
            this.locator.copyFileToContainer(Transferable.of((byte[])fileBytes, (int)438), filename);
        }

        public Gfsh withConnect(List<String> connectOptions) {
            String connectCommand = String.format("connect --jmx-manager=localhost[%d] ", 1099);
            connectCommand = connectCommand + connectOptions.stream().collect(Collectors.joining(" "));
            return new Gfsh(this.locator, connectCommand, this.withLogging);
        }

        public Gfsh build() {
            StringBuilder connectBuilder = new StringBuilder(String.format("connect --jmx-manager=localhost[%d] ", 1099));
            for (Map.Entry<String, String> entry : this.gfshOptions.entrySet()) {
                connectBuilder.append(entry.getKey()).append("=").append(entry.getValue()).append(" ");
            }
            return new Gfsh(this.locator, connectBuilder.toString(), this.withLogging);
        }
    }
}

