/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.gemfire.testcontainers;

import com.vmware.gemfire.testcontainers.AbstractGemFireContainer;
import com.vmware.gemfire.testcontainers.MemberConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.testcontainers.containers.Network;
import org.testcontainers.utility.DockerImageName;

public class GemFireLocatorContainer<SELF extends GemFireLocatorContainer<SELF>>
extends AbstractGemFireContainer<SELF> {
    private static final List<String> DEFAULT_LOCATOR_JVM_ARGS = Collections.unmodifiableList(Arrays.asList("--J=-Dgemfire.use-cluster-configuration=true", "--J=-Dgemfire.jmx-manager-start=true"));

    public GemFireLocatorContainer(MemberConfig config, DockerImageName image, Network network, String locatorAddresses) {
        super(config, image, network, locatorAddresses);
    }

    @Override
    public String getMemberName() {
        return this.config.getMemberName();
    }

    @Override
    protected String startupMessage() {
        return "Locator started on";
    }

    @Override
    protected List<String> getDefaultJvmArgs() {
        return new ArrayList<String>(DEFAULT_LOCATOR_JVM_ARGS);
    }

    protected void configure() {
        this.withCreateContainerCmdModifier(it -> it.withName(this.config.getHostname()).withAliases(new String[]{this.config.getMemberName()}));
        this.config.apply(this);
        ArrayList<String> command = new ArrayList<String>();
        command.add("gfsh");
        command.add("start");
        command.add("locator");
        command.add("--name=" + this.config.getMemberName());
        command.add("--port=" + this.config.getPort());
        command.add("--locators=" + this.locatorAddresses);
        command.add("--hostname-for-clients=" + this.hostnameForClients);
        command.addAll(this.jvmArgs);
        String classpathPart = this.getBinds().stream().map(bind -> bind.getVolume().getPath()).collect(Collectors.joining(":"));
        if (!classpathPart.isEmpty()) {
            command.add("--classpath=" + classpathPart);
        }
        this.withCommand(command.toArray(new String[0]));
        this.logger().info("Starting GemFire locator: {}:{}", (Object)this.config.getMemberName(), (Object)this.config.getProxyPublicPort());
    }

    protected void containerIsCreated(String containerId) {
        this.config.applyPreStart(this);
    }
}

