/*
 * Copyright 2013 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.ide.visualstudio.internal

import spock.lang.Specification

import static org.gradle.ide.visualstudio.internal.VisualStudioTargetBinary.ProjectType.*

class VisualStudioProjectMapperTest extends Specification {


    private VisualStudioTargetBinary targetBinary(Map<String, ?> values) {
        VisualStudioTargetBinary targetBinary = Mock(VisualStudioTargetBinary)
        targetBinary.projectPath >> values.get("projectPath", ":")
        targetBinary.componentName >> values.get("componentName", "exeName")
        targetBinary.variantDimensions >> values.get("variantDimensions", ['buildTypeOne'])
        targetBinary.projectType >> values.get("projectType", EXE)
        return targetBinary
    }


}
