/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.nativeplatform.toolchain.internal.gcc

import org.gradle.nativeplatform.toolchain.internal.OptionsFileArgsWriter
import org.gradle.nativeplatform.toolchain.internal.OptionsFileArgsWriterTest
import org.gradle.test.fixtures.file.TestNameTestDirectoryProvider
import org.junit.Rule
import spock.lang.Unroll

class GccOptionsFileArgsWriterTest extends OptionsFileArgsWriterTest {
    @Rule final TestNameTestDirectoryProvider tmpDirProvider = new TestNameTestDirectoryProvider(getClass())

    OptionsFileArgsWriter getArgsWriter() {
        new GccOptionsFileArgsWriter(tmpDirProvider.getTestDirectory())
    }

    @Unroll
    def "args keep #arg in command line options"() {
        given:
        def argsWriter = getArgsWriter()
        List<String> args = [arg, "strippedArg"]

        when:
        argsWriter.execute(args)

        then:
        args.size() == 2
        args.contains(arg)
        hasOptionsFile(args)

        where:
        arg    | _
        '-m32' | _
        '-m64' | _
    }
}
