/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.ModuleVersionSelectorStrictSpec;
import org.gradle.api.internal.artifacts.dependencies.AbstractModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.base.Strings;

public abstract class AbstractExternalModuleDependency
extends AbstractModuleDependency
implements ExternalModuleDependency {
    private final ModuleIdentifier moduleIdentifier;
    private boolean changing;
    private boolean force;
    private final DefaultMutableVersionConstraint versionConstraint;

    public AbstractExternalModuleDependency(ModuleIdentifier module, String version, @Nullable String configuration) {
        super(configuration);
        if (module == null) {
            throw new InvalidUserDataException("Module must not be null!");
        }
        this.moduleIdentifier = module;
        this.versionConstraint = new DefaultMutableVersionConstraint(version);
    }

    public AbstractExternalModuleDependency(ModuleIdentifier module, MutableVersionConstraint version) {
        super(null);
        if (module == null) {
            throw new InvalidUserDataException("Module must not be null!");
        }
        this.moduleIdentifier = module;
        this.versionConstraint = (DefaultMutableVersionConstraint)version;
    }

    protected void copyTo(AbstractExternalModuleDependency target) {
        super.copyTo(target);
        DeprecationLogger.whileDisabled(() -> target.setForce(this.isForce()));
        target.setChanging(this.isChanging());
    }

    protected boolean isContentEqualsFor(ExternalModuleDependency dependencyRhs) {
        if (!this.isCommonContentEquals(dependencyRhs)) {
            return false;
        }
        return this.force == dependencyRhs.isForce() && this.changing == dependencyRhs.isChanging() && Objects.equal(this.getVersionConstraint(), dependencyRhs.getVersionConstraint());
    }

    @Override
    public boolean matchesStrictly(ModuleVersionIdentifier identifier) {
        return new ModuleVersionSelectorStrictSpec(this).isSatisfiedBy(identifier);
    }

    @Override
    public String getGroup() {
        return this.moduleIdentifier.getGroup();
    }

    @Override
    public String getName() {
        return this.moduleIdentifier.getName();
    }

    @Override
    public String getVersion() {
        return Strings.emptyToNull(this.versionConstraint.getVersion());
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    @Override
    public ExternalModuleDependency setForce(boolean force) {
        this.validateMutation(this.force, force);
        if (force) {
            ((DeprecationMessageBuilder)DeprecationLogger.deprecate("Using force on a dependency").withAdvice("Consider using strict version constraints instead (version { strictly ... } }).")).willBeRemovedInGradle7().withUpgradeGuideSection(5, "forced_dependencies").nagUser();
        }
        this.force = force;
        return this;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public ExternalModuleDependency setChanging(boolean changing) {
        this.validateMutation(this.changing, changing);
        this.changing = changing;
        return this;
    }

    @Override
    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    @Override
    public void version(Action<? super MutableVersionConstraint> configureAction) {
        this.validateMutation();
        configureAction.execute(this.versionConstraint);
    }

    @Override
    public ModuleIdentifier getModule() {
        return this.moduleIdentifier;
    }

    static ModuleIdentifier assertModuleId(@Nullable String group, @Nullable String name) {
        if (name == null) {
            throw new InvalidUserDataException("Name must not be null!");
        }
        return DefaultModuleIdentifier.newId(group, name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractExternalModuleDependency that = (AbstractExternalModuleDependency)o;
        return this.isContentEqualsFor(that);
    }

    public int hashCode() {
        int result = this.getGroup() != null ? this.getGroup().hashCode() : 0;
        result = 31 * result + this.getName().hashCode();
        result = 31 * result + (this.getVersion() != null ? this.getVersion().hashCode() : 0);
        return result;
    }
}

