/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import java.util.List;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.base.Objects;

public abstract class AbstractVersionConstraint
implements VersionConstraint {
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        AbstractVersionConstraint that = (AbstractVersionConstraint)o;
        return Objects.equal(this.getRequiredVersion(), that.getRequiredVersion()) && Objects.equal(this.getPreferredVersion(), that.getPreferredVersion()) && Objects.equal(this.getStrictVersion(), that.getStrictVersion()) && Objects.equal(this.getBranch(), that.getBranch()) && Objects.equal(this.getRejectedVersions(), that.getRejectedVersions());
    }

    public int hashCode() {
        return Objects.hashCode(this.getRequiredVersion(), this.getPreferredVersion(), this.getStrictVersion(), this.getRejectedVersions());
    }

    public String toString() {
        return this.getDisplayName();
    }

    private void append(String name, String version, StringBuilder builder) {
        if (version == null || version.isEmpty()) {
            return;
        }
        if (builder.length() != 1) {
            builder.append("; ");
        }
        builder.append(name);
        builder.append(" ");
        builder.append(version);
    }

    @Override
    public String getDisplayName() {
        String requiredVersion = this.getRequiredVersion();
        if (this.requiredOnly()) {
            return requiredVersion;
        }
        String strictVersion = this.getStrictVersion();
        String preferVersion = this.getPreferredVersion();
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        this.append("strictly", strictVersion, builder);
        if (!requiredVersion.equals(strictVersion)) {
            this.append("require", requiredVersion, builder);
        }
        if (!preferVersion.equals(requiredVersion) && !preferVersion.equals(strictVersion)) {
            this.append("prefer", this.getPreferredVersion(), builder);
        }
        this.append("reject", this.rejectedVersionsString(), builder);
        this.append("branch", this.getBranch(), builder);
        builder.append("}");
        return builder.toString();
    }

    private boolean requiredOnly() {
        return (this.getPreferredVersion().isEmpty() || this.getRequiredVersion().equals(this.getPreferredVersion())) && this.getStrictVersion().isEmpty() && this.getRejectedVersions().isEmpty() && this.getBranch() == null;
    }

    private String rejectedVersionsString() {
        List<String> rejectedVersions = this.getRejectedVersions();
        if (rejectedVersions.size() == 1 && rejectedVersions.get(0).equals("+")) {
            return "all versions";
        }
        return Joiner.on(" & ").join(rejectedVersions);
    }
}

