/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.capabilities.Capability;
import org.gradle.internal.Factory;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.MapNotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypedNotationConverter;

public class CapabilityNotationParserFactory
implements Factory<NotationParser<Object, Capability>> {
    private static final NotationParser<Object, Capability> STRICT_CONVERTER = CapabilityNotationParserFactory.createSingletonConverter(true);
    private static final NotationParser<Object, Capability> LENIENT_CONVERTER = CapabilityNotationParserFactory.createSingletonConverter(false);
    private final boolean versionIsRequired;

    public CapabilityNotationParserFactory(boolean versionIsRequired) {
        this.versionIsRequired = versionIsRequired;
    }

    private static NotationParser<Object, Capability> createSingletonConverter(boolean strict) {
        return NotationParserBuilder.toType(Capability.class).converter(new StringNotationParser(strict)).converter(strict ? new StrictCapabilityMapNotationParser() : new LenientCapabilityMapNotationParser()).toComposite();
    }

    @Override
    @Nullable
    public NotationParser<Object, Capability> create() {
        return this.versionIsRequired ? STRICT_CONVERTER : LENIENT_CONVERTER;
    }

    private static class LenientCapabilityMapNotationParser
    extends MapNotationConverter<Capability> {
        private LenientCapabilityMapNotationParser() {
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Maps").example("[group: 'org.group', name: 'capability', version: '1.0']");
        }

        protected Capability parseMap(@MapKey(value="group") String group, @MapKey(value="name") String name, @MapKey(value="version") @Nullable String version) {
            return new ImmutableCapability(group, name, version);
        }
    }

    private static class StrictCapabilityMapNotationParser
    extends MapNotationConverter<Capability> {
        private StrictCapabilityMapNotationParser() {
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Maps").example("[group: 'org.group', name: 'capability', version: '1.0']");
        }

        protected Capability parseMap(@MapKey(value="group") String group, @MapKey(value="name") String name, @MapKey(value="version") String version) {
            return new ImmutableCapability(group, name, version);
        }
    }

    private static class StringNotationParser
    extends TypedNotationConverter<CharSequence, Capability> {
        private final boolean versionIsRequired;

        StringNotationParser(boolean versionIsRequired) {
            super(CharSequence.class);
            this.versionIsRequired = versionIsRequired;
        }

        @Override
        protected Capability parseType(CharSequence notation) {
            String stringNotation = notation.toString();
            String[] parts = stringNotation.split(":");
            if (parts.length != 3 && (this.versionIsRequired || parts.length != 2)) {
                StringNotationParser.reportInvalidNotation(stringNotation);
            }
            for (String part : parts) {
                if (!StringUtils.isEmpty(part)) continue;
                StringNotationParser.reportInvalidNotation(stringNotation);
            }
            String version = parts.length == 3 ? parts[2] : null;
            return new ImmutableCapability(parts[0], parts[1], version);
        }

        private static void reportInvalidNotation(String notation) {
            throw new InvalidUserDataException("Invalid format for capability: '" + notation + "'. The correct notation is a 3-part group:name:version notation, e.g: 'org.group:capability:1.0'");
        }
    }
}

