/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import org.gradle.api.artifacts.ivy.IvyModuleDescriptor;
import org.gradle.api.artifacts.maven.PomModuleDescriptor;
import org.gradle.api.internal.artifacts.DefaultPomModuleDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.DefaultIvyModuleDescriptor;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ivy.IvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.MavenModuleResolveMetadata;

class MetadataDescriptorFactory {
    private final ModuleComponentResolveMetadata metadata;

    public MetadataDescriptorFactory(ModuleComponentResolveMetadata metadata) {
        this.metadata = metadata;
    }

    public <T> T createDescriptor(Class<T> descriptorClass) {
        if (MetadataDescriptorFactory.isIvyMetadata(descriptorClass, this.metadata)) {
            IvyModuleResolveMetadata ivyMetadata = (IvyModuleResolveMetadata)this.metadata;
            DefaultIvyModuleDescriptor descriptor = new DefaultIvyModuleDescriptor(ivyMetadata.getExtraAttributes(), ivyMetadata.getBranch(), ivyMetadata.getStatus());
            return descriptorClass.cast(descriptor);
        }
        if (MetadataDescriptorFactory.isPomMetadata(descriptorClass, this.metadata)) {
            MavenModuleResolveMetadata mavenMetadata = (MavenModuleResolveMetadata)this.metadata;
            DefaultPomModuleDescriptor descriptor = new DefaultPomModuleDescriptor(mavenMetadata);
            return descriptorClass.cast(descriptor);
        }
        return null;
    }

    public static boolean isMatchingMetadata(Class<?> descriptor, ModuleComponentResolveMetadata metadata) {
        return MetadataDescriptorFactory.isPomMetadata(descriptor, metadata) || MetadataDescriptorFactory.isIvyMetadata(descriptor, metadata);
    }

    private static boolean isIvyMetadata(Class<?> descriptor, ModuleComponentResolveMetadata metadata) {
        return IvyModuleDescriptor.class.isAssignableFrom(descriptor) && metadata instanceof IvyModuleResolveMetadata;
    }

    private static boolean isPomMetadata(Class<?> descriptor, ModuleComponentResolveMetadata metadata) {
        return PomModuleDescriptor.class.isAssignableFrom(descriptor) && metadata instanceof MavenModuleResolveMetadata;
    }
}

