/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy;

import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;

class StaticVersionComparator
implements Comparator<Version> {
    static final Map<String, Integer> SPECIAL_MEANINGS = ImmutableMap.of("dev", -1, "rc", 1, "release", 2, "final", 3);
    static final Map<String, Integer> UPDATED_SPECIAL_MEANINGS = ImmutableMap.builderWithExpectedSize(7).put("dev", -1).put("rc", 1).put("snapshot", 2).put("final", 3).put("ga", 4).put("release", 5).put("sp", 6).build();
    private final Map<String, Integer> specialMeanings;

    public StaticVersionComparator(Map<String, Integer> specialMeanings) {
        this.specialMeanings = specialMeanings;
    }

    @Override
    public int compare(Version version1, Version version2) {
        int i;
        if (version1.equals(version2)) {
            return 0;
        }
        String[] parts1 = version1.getParts();
        String[] parts2 = version2.getParts();
        Long[] numericParts1 = version1.getNumericParts();
        Long[] numericParts2 = version2.getNumericParts();
        for (i = 0; i < parts1.length && i < parts2.length; ++i) {
            boolean is2Number;
            String part1 = parts1[i];
            String part2 = parts2[i];
            Long numericPart1 = numericParts1[i];
            Long numericPart2 = numericParts2[i];
            boolean is1Number = numericPart1 != null;
            boolean bl = is2Number = numericPart2 != null;
            if (part1.equals(part2)) continue;
            if (is1Number && !is2Number) {
                return 1;
            }
            if (is2Number && !is1Number) {
                return -1;
            }
            if (is1Number && is2Number) {
                int result = numericPart1.compareTo(numericPart2);
                if (result == 0) continue;
                return result;
            }
            Integer sm1 = this.specialMeanings.get(part1.toLowerCase(Locale.US));
            Integer sm2 = this.specialMeanings.get(part2.toLowerCase(Locale.US));
            if (sm1 != null) {
                sm2 = sm2 == null ? 0 : sm2;
                return sm1 - sm2;
            }
            if (sm2 != null) {
                return -sm2.intValue();
            }
            return part1.compareTo(part2);
        }
        if (i < parts1.length) {
            return numericParts1[i] == null ? -1 : 1;
        }
        if (i < parts2.length) {
            return numericParts2[i] == null ? 1 : -1;
        }
        return 0;
    }
}

