/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.gradle.internal.impldep.com.google.common.collect.Interner;
import org.gradle.internal.serialize.Decoder;

class StringDeduplicatingDecoder
implements Decoder,
Closeable {
    private final Decoder delegate;
    private final Interner<String> stringInterner;

    StringDeduplicatingDecoder(Decoder delegate, Interner<String> stringInterner) {
        this.delegate = delegate;
        this.stringInterner = stringInterner;
    }

    @Override
    public InputStream getInputStream() {
        return this.delegate.getInputStream();
    }

    @Override
    public long readLong() throws EOFException, IOException {
        return this.delegate.readLong();
    }

    @Override
    public long readSmallLong() throws EOFException, IOException {
        return this.delegate.readSmallLong();
    }

    @Override
    public int readInt() throws EOFException, IOException {
        return this.delegate.readInt();
    }

    @Override
    public int readSmallInt() throws EOFException, IOException {
        return this.delegate.readSmallInt();
    }

    @Override
    @Nullable
    public Integer readNullableSmallInt() throws IOException {
        return this.delegate.readNullableSmallInt();
    }

    @Override
    public boolean readBoolean() throws EOFException, IOException {
        return this.delegate.readBoolean();
    }

    @Override
    public String readString() throws EOFException, IOException {
        return this.stringInterner.intern(this.delegate.readString());
    }

    @Override
    @Nullable
    public String readNullableString() throws EOFException, IOException {
        String str = this.delegate.readNullableString();
        if (str != null) {
            str = this.stringInterner.intern(str);
        }
        return str;
    }

    @Override
    public byte readByte() throws EOFException, IOException {
        return this.delegate.readByte();
    }

    @Override
    public void readBytes(byte[] buffer) throws EOFException, IOException {
        this.delegate.readBytes(buffer);
    }

    @Override
    public void readBytes(byte[] buffer, int offset, int count) throws EOFException, IOException {
        this.delegate.readBytes(buffer, offset, count);
    }

    @Override
    public byte[] readBinary() throws EOFException, IOException {
        return this.delegate.readBinary();
    }

    @Override
    public void skipBytes(long count) throws EOFException, IOException {
        this.delegate.skipBytes(count);
    }

    @Override
    public <T> T decodeChunked(Decoder.DecodeAction<Decoder, T> decodeAction) throws EOFException, Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void skipChunked() throws EOFException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        ((Closeable)((Object)this.delegate)).close();
    }
}

