/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy;

import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.CapabilityResolutionDetails;
import org.gradle.api.artifacts.ComponentVariantIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.CapabilitiesResolutionInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CapabilitiesConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.UpgradeCapabilityResolver;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.Describables;
import org.gradle.internal.component.external.model.CapabilityInternal;
import org.gradle.internal.component.external.model.DefaultComponentVariantIdentifier;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.typeconversion.NotationParser;

public class DefaultCapabilitiesResolution
implements CapabilitiesResolutionInternal {
    private final UpgradeCapabilityResolver upgradeCapabilityResolver = new UpgradeCapabilityResolver();
    private final NotationParser<Object, Capability> capabilityNotationParser;
    private final NotationParser<Object, ComponentIdentifier> componentNotationParser;
    private final List<CapabilityAction> actions = Lists.newArrayListWithExpectedSize(2);

    public DefaultCapabilitiesResolution(NotationParser<Object, Capability> capabilityNotationParser, NotationParser<Object, ComponentIdentifier> componentNotationParser) {
        this.capabilityNotationParser = capabilityNotationParser;
        this.componentNotationParser = componentNotationParser;
    }

    @Override
    public void all(Action<? super CapabilityResolutionDetails> action) {
        this.actions.add(new CapabilityAction(Specs.SATISFIES_ALL, action));
    }

    @Override
    public void withCapability(Capability capability, Action<? super CapabilityResolutionDetails> action) {
        this.actions.add(new CapabilityAction(new CapabilitySpec(capability), action));
    }

    @Override
    public void withCapability(String group, String name, Action<? super CapabilityResolutionDetails> action) {
        this.withCapability(this.capabilityNotationParser.parseNotation(group + ":" + name), action);
    }

    @Override
    public void withCapability(Object notation, Action<? super CapabilityResolutionDetails> action) {
        this.withCapability(this.capabilityNotationParser.parseNotation(notation), action);
    }

    @Override
    public void apply(CapabilitiesConflictHandler.ResolutionDetails details) {
        details.getCapabilityVersions().stream().collect(Collectors.groupingBy(c -> new ImmutableCapability(c.getGroup(), c.getName(), null))).forEach((key1, versions) -> {
            List candidateIds = versions.stream().flatMap(c -> details.getCandidates((Capability)c).stream()).map(detail -> new DefaultComponentVariantIdentifier(detail.getId(), detail.getVariantName())).collect(Collectors.toList());
            DefaultCapabilityResolutionDetails resolutionDetails = new DefaultCapabilityResolutionDetails(this.componentNotationParser, (Capability)key1, candidateIds);
            this.handleCapabilityAction(details, (Capability)key1, (List<? extends Capability>)versions, resolutionDetails);
        });
    }

    private void handleCapabilityAction(CapabilitiesConflictHandler.ResolutionDetails details, Capability key, List<? extends Capability> versions, DefaultCapabilityResolutionDetails resolutionDetails) {
        for (CapabilityAction action : this.actions) {
            if (!action.predicate.isSatisfiedBy(key)) continue;
            action.execute(resolutionDetails);
            if (!resolutionDetails.didSomething) continue;
            this.performCapabilitySelection(details, versions, resolutionDetails);
        }
    }

    private void performCapabilitySelection(CapabilitiesConflictHandler.ResolutionDetails details, List<? extends Capability> versions, DefaultCapabilityResolutionDetails resolutionDetails) {
        if (resolutionDetails.useHighest) {
            this.upgradeCapabilityResolver.resolve(details);
        } else if (resolutionDetails.selected != null) {
            versions.forEach(version -> details.getCandidates((Capability)version).forEach(cand -> this.selectExplicitCandidate(resolutionDetails, (CapabilityInternal)version, (CapabilitiesConflictHandler.CandidateDetails)cand)));
        }
    }

    private void selectExplicitCandidate(DefaultCapabilityResolutionDetails resolutionDetails, CapabilityInternal version, CapabilitiesConflictHandler.CandidateDetails cand) {
        if (cand.getId().equals(resolutionDetails.selected.getId())) {
            if (cand.getVariantName().equals(resolutionDetails.selected.getVariantName())) {
                cand.select();
                String reason = resolutionDetails.reason;
                if (reason != null) {
                    cand.byReason(Describables.of("On capability", version.getCapabilityId(), reason));
                }
            } else {
                cand.evict();
            }
        }
    }

    private static class CapabilitySpec
    implements Spec<Capability> {
        private final Capability capability;

        public CapabilitySpec(Capability capability) {
            this.capability = capability;
        }

        @Override
        public boolean isSatisfiedBy(Capability element) {
            return element.getGroup().equals(this.capability.getGroup()) && element.getName().equals(this.capability.getName());
        }
    }

    private static class CapabilityAction {
        private final Spec<? super Capability> predicate;
        private final Action<? super CapabilityResolutionDetails> action;

        private CapabilityAction(Spec<? super Capability> predicate, Action<? super CapabilityResolutionDetails> action) {
            this.predicate = predicate;
            this.action = action;
        }

        public void execute(DefaultCapabilityResolutionDetails resolutionDetails) {
            try {
                this.action.execute(resolutionDetails);
            }
            catch (Exception ex) {
                if (ex instanceof InvalidUserCodeException) {
                    throw ex;
                }
                throw new InvalidUserCodeException("Capability resolution rule failed with an error", ex);
            }
        }
    }

    private static class DefaultCapabilityResolutionDetails
    implements CapabilityResolutionDetails {
        private final NotationParser<Object, ComponentIdentifier> notationParser;
        private final Capability capability;
        private final List<ComponentVariantIdentifier> candidates;
        boolean didSomething;
        boolean useHighest;
        private String reason;
        private ComponentVariantIdentifier selected;

        private DefaultCapabilityResolutionDetails(NotationParser<Object, ComponentIdentifier> notationParser, Capability capability, List<ComponentVariantIdentifier> candidates) {
            this.notationParser = notationParser;
            this.capability = capability;
            this.candidates = candidates;
        }

        @Override
        public Capability getCapability() {
            return this.capability;
        }

        @Override
        public List<ComponentVariantIdentifier> getCandidates() {
            return this.candidates;
        }

        @Override
        public CapabilityResolutionDetails select(ComponentVariantIdentifier candidate) {
            this.didSomething = true;
            this.selected = candidate;
            return this;
        }

        @Override
        public CapabilityResolutionDetails select(Object notation) {
            ComponentIdentifier componentIdentifier = this.notationParser.parseNotation(notation);
            for (ComponentVariantIdentifier candidate : this.candidates) {
                if (componentIdentifier.equals(candidate.getId())) {
                    this.select(candidate);
                    return this;
                }
                if (!(candidate.getId() instanceof ModuleComponentIdentifier) || !(componentIdentifier instanceof ModuleComponentIdentifier)) continue;
                ModuleComponentIdentifier candMCI = (ModuleComponentIdentifier)candidate.getId();
                ModuleComponentIdentifier compMCI = (ModuleComponentIdentifier)componentIdentifier;
                if (!candMCI.getModuleIdentifier().equals(compMCI.getModuleIdentifier())) continue;
                this.select(candidate);
                return this;
            }
            throw new InvalidUserCodeException(componentIdentifier + " is not a valid candidate for conflict resolution on capability " + this.capability + ": candidates are " + this.candidates);
        }

        @Override
        public CapabilityResolutionDetails selectHighestVersion() {
            this.didSomething = true;
            this.useHighest = true;
            return this;
        }

        @Override
        public CapabilityResolutionDetails because(String reason) {
            this.reason = reason;
            return this;
        }
    }
}

