/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphDependency;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.RootGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentResultSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectorSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DefaultResolutionResultBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DependencyResultSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolvedVariantResultSerializer;
import org.gradle.api.internal.artifacts.result.DefaultResolutionResult;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.internal.BinaryStore;
import org.gradle.cache.internal.Store;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;

public class StreamingResolutionResultBuilder
implements DependencyGraphVisitor {
    private static final byte ROOT = 1;
    private static final byte COMPONENT = 2;
    private static final byte SELECTOR = 4;
    private static final byte DEPENDENCY = 5;
    private final Map<ComponentSelector, ModuleVersionResolveException> failures = new HashMap<ComponentSelector, ModuleVersionResolveException>();
    private final BinaryStore store;
    private final ComponentResultSerializer componentResultSerializer;
    private final Store<ResolvedComponentResult> cache;
    private final ComponentSelectorSerializer componentSelectorSerializer;
    private final DependencyResultSerializer dependencyResultSerializer;
    private final Set<Long> visitedComponents = new HashSet<Long>();
    private final AttributeContainerSerializer attributeContainerSerializer;
    private final AttributeDesugaring desugaring;
    private AttributeContainer rootAttributes;
    private boolean mayHaveVirtualPlatforms;

    public StreamingResolutionResultBuilder(BinaryStore store, Store<ResolvedComponentResult> cache2, ImmutableModuleIdentifierFactory moduleIdentifierFactory, AttributeContainerSerializer attributeContainerSerializer, AttributeDesugaring desugaring, ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory) {
        ComponentIdentifierSerializer componentIdentifierSerializer = new ComponentIdentifierSerializer();
        ResolvedVariantResultSerializer resolvedVariantResultSerializer = new ResolvedVariantResultSerializer(componentIdentifierSerializer, attributeContainerSerializer);
        this.dependencyResultSerializer = new DependencyResultSerializer(resolvedVariantResultSerializer, componentSelectionDescriptorFactory);
        this.componentResultSerializer = new ComponentResultSerializer(moduleIdentifierFactory, resolvedVariantResultSerializer, componentSelectionDescriptorFactory, componentIdentifierSerializer);
        this.store = store;
        this.cache = cache2;
        this.componentSelectorSerializer = new ComponentSelectorSerializer(attributeContainerSerializer);
        this.attributeContainerSerializer = attributeContainerSerializer;
        this.desugaring = desugaring;
    }

    public ResolutionResult complete(Set<UnresolvedDependency> extraFailures) {
        BinaryStore.BinaryData data = this.store.done();
        RootFactory rootSource = new RootFactory(data, this.failures, this.cache, this.componentSelectorSerializer, this.dependencyResultSerializer, this.componentResultSerializer, this.attributeContainerSerializer, extraFailures);
        return new DefaultResolutionResult(rootSource, this.rootAttributes);
    }

    @Override
    public void start(RootGraphNode root) {
        this.rootAttributes = this.desugaring.desugar(root.getMetadata().getAttributes());
        this.mayHaveVirtualPlatforms = root.getResolveOptimizations().mayHaveVirtualPlatforms();
    }

    @Override
    public void finish(DependencyGraphNode root) {
        this.store.write(encoder -> {
            encoder.writeByte((byte)1);
            encoder.writeSmallLong(root.getOwner().getResultId());
            this.attributeContainerSerializer.write(encoder, this.rootAttributes);
        });
    }

    @Override
    public void visitNode(DependencyGraphNode node) {
        DependencyGraphComponent component = node.getOwner();
        if (this.visitedComponents.add(component.getResultId())) {
            this.store.write(encoder -> {
                encoder.writeByte((byte)2);
                this.componentResultSerializer.write(encoder, component);
            });
        }
    }

    @Override
    public void visitSelector(DependencyGraphSelector selector) {
        this.store.write(encoder -> {
            encoder.writeByte((byte)4);
            encoder.writeSmallLong(selector.getResultId());
            this.componentSelectorSerializer.write(encoder, selector.getRequested());
        });
    }

    @Override
    public void visitEdges(DependencyGraphNode node) {
        Collection dependencies;
        Long fromComponent = node.getOwner().getResultId();
        Collection collection = dependencies = this.mayHaveVirtualPlatforms ? (Collection)node.getOutgoingEdges().stream().filter(dep -> !dep.isTargetVirtualPlatform()).collect(Collectors.toList()) : node.getOutgoingEdges();
        if (!dependencies.isEmpty()) {
            this.store.write(encoder -> {
                encoder.writeByte((byte)5);
                encoder.writeSmallLong(fromComponent);
                encoder.writeSmallInt(dependencies.size());
                for (DependencyGraphEdge dependency : dependencies) {
                    this.dependencyResultSerializer.write(encoder, dependency);
                    if (dependency.getFailure() == null) continue;
                    this.failures.put(dependency.getRequested(), dependency.getFailure());
                }
            });
        }
    }

    private static class RootFactory
    implements Factory<ResolvedComponentResult> {
        private static final Logger LOG = Logging.getLogger(RootFactory.class);
        private final ComponentResultSerializer componentResultSerializer;
        private final BinaryStore.BinaryData data;
        private final Map<ComponentSelector, ModuleVersionResolveException> failures;
        private final Store<ResolvedComponentResult> cache;
        private final Object lock = new Object();
        private final ComponentSelectorSerializer componentSelectorSerializer;
        private final DependencyResultSerializer dependencyResultSerializer;
        private final AttributeContainerSerializer attributeContainerSerializer;
        private final Set<UnresolvedDependency> extraFailures;

        RootFactory(BinaryStore.BinaryData data, Map<ComponentSelector, ModuleVersionResolveException> failures, Store<ResolvedComponentResult> cache2, ComponentSelectorSerializer componentSelectorSerializer, DependencyResultSerializer dependencyResultSerializer, ComponentResultSerializer componentResultSerializer, AttributeContainerSerializer attributeContainerSerializer, Set<UnresolvedDependency> extraFailures) {
            this.data = data;
            this.failures = failures;
            this.cache = cache2;
            this.componentResultSerializer = componentResultSerializer;
            this.componentSelectorSerializer = componentSelectorSerializer;
            this.dependencyResultSerializer = dependencyResultSerializer;
            this.attributeContainerSerializer = attributeContainerSerializer;
            this.extraFailures = extraFailures;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResolvedComponentResult create() {
            Object object = this.lock;
            synchronized (object) {
                return this.cache.load(() -> {
                    try {
                        ResolvedComponentResult resolvedComponentResult = this.data.read(this::deserialize);
                        return resolvedComponentResult;
                    }
                    finally {
                        try {
                            this.data.close();
                        }
                        catch (IOException e) {
                            throw UncheckedException.throwAsUncheckedException(e);
                        }
                    }
                });
            }
        }

        private ResolvedComponentResult deserialize(Decoder decoder) {
            this.componentSelectorSerializer.reset();
            this.componentResultSerializer.reset();
            int valuesRead = 0;
            int type = -1;
            Timer clock = Time.startTimer();
            try {
                DefaultResolutionResultBuilder builder = new DefaultResolutionResultBuilder();
                HashMap<Long, ComponentSelector> selectors = new HashMap<Long, ComponentSelector>();
                block8: while (true) {
                    type = decoder.readByte();
                    ++valuesRead;
                    switch (type) {
                        case 1: {
                            Long rootId = decoder.readSmallLong();
                            builder.setRequestedAttributes(this.attributeContainerSerializer.read(decoder));
                            builder.addExtraFailures(rootId, this.extraFailures);
                            ResolvedComponentResult root = builder.complete(rootId).getRoot();
                            LOG.debug("Loaded resolution results ({}) from {}", (Object)clock.getElapsed(), (Object)this.data);
                            return root;
                        }
                        case 2: {
                            ResolvedGraphComponent component = this.componentResultSerializer.read(decoder);
                            builder.visitComponent(component);
                            continue block8;
                        }
                        case 4: {
                            Long id = decoder.readSmallLong();
                            ComponentSelector selector = this.componentSelectorSerializer.read(decoder);
                            selectors.put(id, selector);
                            continue block8;
                        }
                        case 5: {
                            Long fromId = decoder.readSmallLong();
                            int size = decoder.readSmallInt();
                            if (size <= 0) continue block8;
                            ArrayList<ResolvedGraphDependency> deps = Lists.newArrayListWithExpectedSize(size);
                            for (int i = 0; i < size; ++i) {
                                deps.add(this.dependencyResultSerializer.read(decoder, selectors, this.failures));
                            }
                            builder.visitOutgoingEdges(fromId, deps);
                            continue block8;
                        }
                    }
                    break;
                }
                throw new IOException("Unknown value type read from stream: " + type);
            }
            catch (IOException e) {
                throw new RuntimeException("Problems loading the resolution results (" + clock.getElapsed() + "). Read " + valuesRead + " values, last was: " + type, e);
            }
        }
    }
}

