/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.publish;

import java.io.File;
import java.util.Date;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.PublishArtifactInternal;
import org.gradle.api.internal.artifacts.publish.AbstractPublishArtifact;
import org.gradle.util.GUtil;

public class DecoratingPublishArtifact
extends AbstractPublishArtifact
implements ConfigurablePublishArtifact {
    private String name;
    private String extension;
    private String type;
    private String classifier;
    private final PublishArtifact publishArtifact;
    private boolean classifierSet;

    public DecoratingPublishArtifact(PublishArtifact publishArtifact) {
        super(publishArtifact.getBuildDependencies());
        this.publishArtifact = publishArtifact;
    }

    public PublishArtifact getPublishArtifact() {
        return this.publishArtifact;
    }

    @Override
    public DecoratingPublishArtifact builtBy(Object ... tasks) {
        super.builtBy(tasks);
        return this;
    }

    @Override
    public String getName() {
        return GUtil.getOrDefault(this.name, this.publishArtifact::getName);
    }

    @Override
    public String getExtension() {
        return GUtil.getOrDefault(this.extension, this.publishArtifact::getExtension);
    }

    @Override
    public String getType() {
        return GUtil.getOrDefault(this.type, this.publishArtifact::getType);
    }

    @Override
    public String getClassifier() {
        if (this.classifierSet) {
            return this.classifier;
        }
        return this.publishArtifact.getClassifier();
    }

    @Override
    public File getFile() {
        return this.publishArtifact.getFile();
    }

    @Override
    public Date getDate() {
        return this.publishArtifact.getDate();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void setClassifier(String classifier) {
        this.classifier = classifier;
        this.classifierSet = true;
    }

    @Override
    public boolean shouldBePublished() {
        if (this.publishArtifact instanceof PublishArtifactInternal) {
            return ((PublishArtifactInternal)this.publishArtifact).shouldBePublished();
        }
        return true;
    }
}

