/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.DefaultVersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.DefaultVersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.artifacts.repositories.ArtifactResolutionDetails;
import org.gradle.api.internal.artifacts.repositories.RepositoryContentDescriptorInternal;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableCollection;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

class DefaultRepositoryContentDescriptor
implements RepositoryContentDescriptorInternal {
    private Set<String> includedConfigurations;
    private Set<String> excludedConfigurations;
    private Set<ContentSpec> includeSpecs;
    private Set<ContentSpec> excludeSpecs;
    private Map<Attribute<Object>, Set<Object>> requiredAttributes;
    private boolean locked;
    private Action<? super ArtifactResolutionDetails> cachedAction;
    private final Supplier<String> repositoryNameSupplier;
    private final VersionSelectorScheme versionSelectorScheme;
    private final ConcurrentHashMap<String, VersionSelector> versionSelectors = new ConcurrentHashMap();

    public DefaultRepositoryContentDescriptor(Supplier<String> repositoryNameSupplier, FeaturePreviews featurePreviews) {
        this.versionSelectorScheme = new DefaultVersionSelectorScheme(new DefaultVersionComparator(featurePreviews), new VersionParser());
        this.repositoryNameSupplier = repositoryNameSupplier;
    }

    private void assertMutable() {
        if (this.locked) {
            throw new IllegalStateException("Cannot mutate content repository descriptor '" + this.repositoryNameSupplier.get() + "' after repository has been used");
        }
    }

    @Override
    public Action<? super ArtifactResolutionDetails> toContentFilter() {
        if (this.cachedAction != null) {
            return this.cachedAction;
        }
        this.locked = true;
        if (this.includedConfigurations == null && this.excludedConfigurations == null && this.includeSpecs == null && this.excludeSpecs == null && this.requiredAttributes == null) {
            return Actions.doNothing();
        }
        this.cachedAction = new RepositoryFilterAction(DefaultRepositoryContentDescriptor.createSpecMatchers(this.includeSpecs), DefaultRepositoryContentDescriptor.createSpecMatchers(this.excludeSpecs));
        return this.cachedAction;
    }

    @Nullable
    private static ImmutableList<SpecMatcher> createSpecMatchers(@Nullable Set<ContentSpec> specs) {
        ImmutableCollection matchers = null;
        if (specs != null) {
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize(specs.size());
            for (ContentSpec spec : specs) {
                builder.add(spec.toMatcher());
            }
            matchers = builder.build();
        }
        return matchers;
    }

    @Override
    public void includeGroup(String group) {
        DefaultRepositoryContentDescriptor.checkNotNull(group, "Group cannot be null");
        this.addInclude(group, null, null, false);
    }

    private static void checkNotNull(@Nullable String value, String message2) {
        if (value == null) {
            throw new IllegalArgumentException(message2);
        }
    }

    @Override
    public void includeGroupByRegex(String groupRegex) {
        DefaultRepositoryContentDescriptor.checkNotNull(groupRegex, "Group cannot be null");
        this.addInclude(groupRegex, null, null, true);
    }

    @Override
    public void includeModule(String group, String moduleName) {
        DefaultRepositoryContentDescriptor.checkNotNull(group, "Group cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(moduleName, "Module name cannot be null");
        this.addInclude(group, moduleName, null, false);
    }

    @Override
    public void includeModuleByRegex(String groupRegex, String moduleNameRegex) {
        DefaultRepositoryContentDescriptor.checkNotNull(groupRegex, "Group cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(moduleNameRegex, "Module name cannot be null");
        this.addInclude(groupRegex, moduleNameRegex, null, true);
    }

    @Override
    public void includeVersion(String group, String moduleName, String version) {
        DefaultRepositoryContentDescriptor.checkNotNull(group, "Group cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(moduleName, "Module name cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(version, "Version cannot be null");
        this.addInclude(group, moduleName, version, false);
    }

    @Override
    public void includeVersionByRegex(String groupRegex, String moduleNameRegex, String versionRegex) {
        DefaultRepositoryContentDescriptor.checkNotNull(groupRegex, "Group cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(moduleNameRegex, "Module name cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(versionRegex, "Version cannot be null");
        this.addInclude(groupRegex, moduleNameRegex, versionRegex, true);
    }

    private void addInclude(String group, @Nullable String moduleName, @Nullable String version, boolean regex) {
        this.assertMutable();
        if (this.includeSpecs == null) {
            this.includeSpecs = Sets.newHashSet();
        }
        this.includeSpecs.add(new ContentSpec(regex, group, moduleName, version, this.versionSelectorScheme, this.versionSelectors, true));
    }

    @Override
    public void excludeGroup(String group) {
        DefaultRepositoryContentDescriptor.checkNotNull(group, "Group cannot be null");
        this.addExclude(group, null, null, false);
    }

    @Override
    public void excludeGroupByRegex(String groupRegex) {
        DefaultRepositoryContentDescriptor.checkNotNull(groupRegex, "Group cannot be null");
        this.addExclude(groupRegex, null, null, true);
    }

    @Override
    public void excludeModule(String group, String moduleName) {
        DefaultRepositoryContentDescriptor.checkNotNull(group, "Group cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(moduleName, "Module name cannot be null");
        this.addExclude(group, moduleName, null, false);
    }

    @Override
    public void excludeModuleByRegex(String groupRegex, String moduleNameRegex) {
        DefaultRepositoryContentDescriptor.checkNotNull(groupRegex, "Group cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(moduleNameRegex, "Module name cannot be null");
        this.addExclude(groupRegex, moduleNameRegex, null, true);
    }

    @Override
    public void excludeVersion(String group, String moduleName, String version) {
        DefaultRepositoryContentDescriptor.checkNotNull(group, "Group cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(moduleName, "Module name cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(version, "Version cannot be null");
        this.addExclude(group, moduleName, version, false);
    }

    @Override
    public void excludeVersionByRegex(String groupRegex, String moduleNameRegex, String versionRegex) {
        DefaultRepositoryContentDescriptor.checkNotNull(groupRegex, "Group cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(moduleNameRegex, "Module name cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(versionRegex, "Version cannot be null");
        this.addExclude(groupRegex, moduleNameRegex, versionRegex, true);
    }

    private void addExclude(String group, @Nullable String moduleName, @Nullable String version, boolean regex) {
        this.assertMutable();
        if (this.excludeSpecs == null) {
            this.excludeSpecs = Sets.newHashSet();
        }
        this.excludeSpecs.add(new ContentSpec(regex, group, moduleName, version, this.versionSelectorScheme, this.versionSelectors, false));
    }

    @Override
    public void onlyForConfigurations(String ... configurationNames) {
        if (this.includedConfigurations == null) {
            this.includedConfigurations = Sets.newHashSet();
        }
        Collections.addAll(this.includedConfigurations, configurationNames);
    }

    @Override
    public void notForConfigurations(String ... configurationNames) {
        if (this.excludedConfigurations == null) {
            this.excludedConfigurations = Sets.newHashSet();
        }
        Collections.addAll(this.excludedConfigurations, configurationNames);
    }

    @Override
    public <T> void onlyForAttribute(Attribute<T> attribute, T ... validValues) {
        if (this.requiredAttributes == null) {
            this.requiredAttributes = Maps.newHashMap();
        }
        this.requiredAttributes.put((Attribute)Cast.uncheckedCast(attribute), ImmutableSet.copyOf(validValues));
    }

    private class RepositoryFilterAction
    implements Action<ArtifactResolutionDetails> {
        private final ImmutableList<SpecMatcher> includeMatchers;
        private final ImmutableList<SpecMatcher> excludeMatchers;

        public RepositoryFilterAction(@Nullable ImmutableList<SpecMatcher> includeMatchers, ImmutableList<SpecMatcher> excludeMatchers) {
            this.includeMatchers = includeMatchers;
            this.excludeMatchers = excludeMatchers;
        }

        @Override
        public void execute(ArtifactResolutionDetails details) {
            if (DefaultRepositoryContentDescriptor.this.includedConfigurations != null && !DefaultRepositoryContentDescriptor.this.includedConfigurations.contains(details.getConsumerName())) {
                details.notFound();
                return;
            }
            if (DefaultRepositoryContentDescriptor.this.excludedConfigurations != null && DefaultRepositoryContentDescriptor.this.excludedConfigurations.contains(details.getConsumerName())) {
                details.notFound();
                return;
            }
            if (this.includeMatchers != null && !this.anyMatch(this.includeMatchers, details)) {
                details.notFound();
                return;
            }
            if (this.excludeMatchers != null && this.anyMatch(this.excludeMatchers, details)) {
                details.notFound();
                return;
            }
            if (this.anyAttributesExcludes(details)) {
                details.notFound();
            }
        }

        private boolean anyAttributesExcludes(ArtifactResolutionDetails details) {
            if (DefaultRepositoryContentDescriptor.this.requiredAttributes != null) {
                AttributeContainer consumerAttributes = details.getConsumerAttributes();
                for (Map.Entry entry : DefaultRepositoryContentDescriptor.this.requiredAttributes.entrySet()) {
                    Object value;
                    Attribute key = (Attribute)entry.getKey();
                    Set allowedValues = (Set)entry.getValue();
                    if (allowedValues.contains(value = consumerAttributes.getAttribute(key))) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean anyMatch(ImmutableList<SpecMatcher> matchers, ArtifactResolutionDetails details) {
            for (SpecMatcher matcher : matchers) {
                boolean matches = details.isVersionListing() ? matcher.matches(details.getModuleId()) : matcher.matches(details.getComponentId());
                if (!matches) continue;
                return true;
            }
            return false;
        }
    }

    private static class PatternSpecMatcher
    implements SpecMatcher {
        private final Pattern groupPattern;
        private final Pattern modulePattern;
        private final Pattern versionPattern;
        private final boolean inclusive;

        private PatternSpecMatcher(String group, @Nullable String module, @Nullable String version, boolean inclusive) {
            this.groupPattern = Pattern.compile(group);
            this.modulePattern = module == null ? null : Pattern.compile(module);
            this.versionPattern = version == null ? null : Pattern.compile(version);
            this.inclusive = inclusive;
        }

        @Override
        public boolean matches(ModuleIdentifier id) {
            return !(!this.groupPattern.matcher(id.getGroup()).matches() || this.modulePattern != null && !this.modulePattern.matcher(id.getName()).matches() || !this.inclusive && this.versionPattern != null);
        }

        @Override
        public boolean matches(ModuleComponentIdentifier id) {
            return !(!this.groupPattern.matcher(id.getGroup()).matches() || this.modulePattern != null && !this.modulePattern.matcher(id.getModule()).matches() || this.versionPattern != null && !this.versionPattern.matcher(id.getVersion()).matches());
        }
    }

    private static class SimpleSpecMatcher
    implements SpecMatcher {
        private final String group;
        private final String module;
        private final String version;
        private final VersionSelector versionSelector;
        private final boolean inclusive;

        private SimpleSpecMatcher(String group, @Nullable String module, @Nullable String version, VersionSelectorScheme versionSelectorScheme, ConcurrentHashMap<String, VersionSelector> versionSelectors, boolean inclusive) {
            this.group = group;
            this.module = module;
            this.version = version;
            this.inclusive = inclusive;
            this.versionSelector = this.getVersionSelector(versionSelectors, versionSelectorScheme, version);
        }

        @Override
        public boolean matches(ModuleIdentifier id) {
            return !(!this.group.equals(id.getGroup()) || this.module != null && !this.module.equals(id.getName()) || !this.inclusive && this.version != null);
        }

        @Override
        public boolean matches(ModuleComponentIdentifier id) {
            return !(!this.group.equals(id.getGroup()) || this.module != null && !this.module.equals(id.getModule()) || this.version != null && !this.version.equals(id.getVersion()) && !this.versionSelector.accept(id.getVersion()));
        }

        @Nullable
        private VersionSelector getVersionSelector(ConcurrentHashMap<String, VersionSelector> versionSelectors, VersionSelectorScheme versionSelectorScheme, @Nullable String version) {
            return version != null ? versionSelectors.computeIfAbsent(version, s -> versionSelectorScheme.parseSelector(version)) : null;
        }
    }

    private static interface SpecMatcher {
        public boolean matches(ModuleIdentifier var1);

        public boolean matches(ModuleComponentIdentifier var1);
    }

    private static class ContentSpec {
        private final boolean regex;
        private final String group;
        private final String module;
        private final String version;
        private final VersionSelectorScheme versionSelectorScheme;
        private final ConcurrentHashMap<String, VersionSelector> versionSelectors;
        private final boolean inclusive;
        private final int hashCode;

        private ContentSpec(boolean regex, String group, @Nullable String module, @Nullable String version, VersionSelectorScheme versionSelectorScheme, ConcurrentHashMap<String, VersionSelector> versionSelectors, boolean inclusive) {
            this.regex = regex;
            this.group = group;
            this.module = module;
            this.version = version;
            this.versionSelectorScheme = versionSelectorScheme;
            this.versionSelectors = versionSelectors;
            this.inclusive = inclusive;
            this.hashCode = Objects.hashCode(regex, group, module, version, inclusive);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContentSpec that = (ContentSpec)o;
            return this.regex == that.regex && this.hashCode == that.hashCode && Objects.equal(this.group, that.group) && Objects.equal(this.module, that.module) && Objects.equal(this.version, that.version) && Objects.equal(this.inclusive, that.inclusive);
        }

        public int hashCode() {
            return this.hashCode;
        }

        SpecMatcher toMatcher() {
            if (this.regex) {
                return new PatternSpecMatcher(this.group, this.module, this.version, this.inclusive);
            }
            return new SimpleSpecMatcher(this.group, this.module, this.version, this.versionSelectorScheme, this.versionSelectors, this.inclusive);
        }
    }
}

