/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.metadata;

import java.util.Collection;
import java.util.List;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.repositories.metadata.MutableModuleMetadataFactory;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.model.PreferJavaRuntimeVariant;
import org.gradle.internal.component.external.model.ivy.DefaultMutableIvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.ivy.IvyDependencyDescriptor;
import org.gradle.internal.component.external.model.ivy.MutableIvyModuleResolveMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public class IvyMutableModuleMetadataFactory
implements MutableModuleMetadataFactory<MutableIvyModuleResolveMetadata> {
    private static final Configuration DEFAULT_CONFIGURATION = new Configuration("default", true, true, ImmutableSet.of());
    private static final List<Configuration> DEFAULT_CONFIGURATION_LIST = ImmutableList.of(DEFAULT_CONFIGURATION);
    private static final ImmutableSet<String> SINGLE_DEFAULT_CONFIGURATION_NAME = ImmutableSet.of("default");
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final ImmutableAttributesFactory attributesFactory;
    private final PreferJavaRuntimeVariant schema;

    public IvyMutableModuleMetadataFactory(ImmutableModuleIdentifierFactory moduleIdentifierFactory, ImmutableAttributesFactory attributesFactory, PreferJavaRuntimeVariant schema) {
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.attributesFactory = attributesFactory;
        this.schema = schema;
    }

    public MutableIvyModuleResolveMetadata create(ModuleComponentIdentifier from, List<IvyDependencyDescriptor> dependencies) {
        return this.create(from, dependencies, DEFAULT_CONFIGURATION_LIST, this.createDefaultArtifact(from), ImmutableList.of());
    }

    public MutableIvyModuleResolveMetadata create(ModuleComponentIdentifier from, List<IvyDependencyDescriptor> dependencies, Collection<Configuration> configurationDefinitions, Collection<? extends Artifact> artifactDefinitions, Collection<? extends Exclude> excludes) {
        ModuleVersionIdentifier mvi = this.asVersionIdentifier(from);
        return new DefaultMutableIvyModuleResolveMetadata(this.attributesFactory, mvi, from, dependencies, configurationDefinitions, artifactDefinitions, excludes, this.schema);
    }

    @Override
    public MutableIvyModuleResolveMetadata createForGradleModuleMetadata(ModuleComponentIdentifier from) {
        return this.create(from, ImmutableList.of(), ImmutableList.of(), this.createDefaultArtifact(from), ImmutableList.of());
    }

    private ImmutableList<? extends Artifact> createDefaultArtifact(ModuleComponentIdentifier from) {
        return ImmutableList.of(new Artifact(new DefaultIvyArtifactName(from.getModule(), "jar", "jar"), SINGLE_DEFAULT_CONFIGURATION_NAME));
    }

    private ModuleVersionIdentifier asVersionIdentifier(ModuleComponentIdentifier from) {
        return this.moduleIdentifierFactory.moduleWithVersion(from.getGroup(), from.getModule(), from.getVersion());
    }

    @Override
    public MutableIvyModuleResolveMetadata missing(ModuleComponentIdentifier from) {
        MutableIvyModuleResolveMetadata metadata = this.create(from, ImmutableList.of());
        metadata.setMissing(true);
        return metadata;
    }
}

