/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.impldep.org.apache.ivy.core.IvyPatternHelper;
import org.gradle.internal.resource.ExternalResourceName;

abstract class AbstractResourcePattern
implements ResourcePattern {
    public static final String CLASSIFIER_KEY = "classifier";
    private final ExternalResourceName pattern;
    private final boolean revisionIsOptional;
    private final boolean organisationIsOptional;
    private final boolean artifactIsOptional;
    private final boolean classifierIsOptional;
    private final boolean extensionIsOptional;
    private final boolean typeIsOptional;

    public AbstractResourcePattern(String pattern) {
        this(new ExternalResourceName(pattern));
    }

    public AbstractResourcePattern(URI baseUri, String pattern) {
        this(new ExternalResourceName(baseUri, pattern));
    }

    private AbstractResourcePattern(ExternalResourceName pattern) {
        this.pattern = pattern;
        this.revisionIsOptional = this.isOptionalToken("revision");
        this.organisationIsOptional = this.isOptionalToken("organisation", "organization");
        this.artifactIsOptional = this.isOptionalToken("artifact");
        this.classifierIsOptional = this.isOptionalToken(CLASSIFIER_KEY);
        this.extensionIsOptional = this.isOptionalToken("ext");
        this.typeIsOptional = this.isOptionalToken("type");
    }

    @Override
    public String getPattern() {
        return this.pattern.getDecoded();
    }

    protected ExternalResourceName getBase() {
        return this.pattern;
    }

    protected String substituteTokens(String pattern, Map<String, String> attributes) {
        return IvyPatternHelper.substituteTokens(pattern, attributes);
    }

    protected Map<String, String> toAttributes(ModuleComponentArtifactMetadata artifact) {
        Map<String, String> attributes = this.toAttributes(artifact.getId().getComponentIdentifier());
        attributes.putAll(this.toAttributes(artifact.getName()));
        return attributes;
    }

    protected Map<String, String> toAttributes(ModuleIdentifier module, IvyArtifactName ivyArtifactName) {
        Map<String, String> attributes = this.toAttributes(module);
        attributes.putAll(this.toAttributes(ivyArtifactName));
        return attributes;
    }

    protected Map<String, String> toAttributes(IvyArtifactName ivyArtifact) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("artifact", ivyArtifact.getName());
        attributes.put("type", ivyArtifact.getType());
        attributes.put("ext", ivyArtifact.getExtension());
        attributes.put(CLASSIFIER_KEY, ivyArtifact.getClassifier());
        return attributes;
    }

    protected Map<String, String> toAttributes(ModuleIdentifier module) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("organisation", module.getGroup());
        attributes.put("module", module.getName());
        return attributes;
    }

    protected Map<String, String> toAttributes(ModuleComponentIdentifier componentIdentifier) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("organisation", componentIdentifier.getGroup());
        attributes.put("module", componentIdentifier.getModule());
        attributes.put("revision", componentIdentifier.getVersion());
        return attributes;
    }

    @Override
    public boolean isComplete(ModuleIdentifier moduleIdentifier) {
        return this.isValidSubstitute(moduleIdentifier.getName(), false) && this.isValidSubstitute(moduleIdentifier.getGroup(), this.organisationIsOptional);
    }

    @Override
    public boolean isComplete(ModuleComponentIdentifier componentIdentifier) {
        return this.isValidSubstitute(componentIdentifier.getModule(), false) && this.isValidSubstitute(componentIdentifier.getGroup(), this.organisationIsOptional) && this.isValidSubstitute(componentIdentifier.getVersion(), this.revisionIsOptional);
    }

    @Override
    public boolean isComplete(ModuleComponentArtifactMetadata artifactIdentifier) {
        IvyArtifactName artifactName = artifactIdentifier.getName();
        ModuleComponentIdentifier componentIdentifier = artifactIdentifier.getId().getComponentIdentifier();
        return this.isValidSubstitute(componentIdentifier.getModule(), false) && this.isValidSubstitute(componentIdentifier.getGroup(), this.organisationIsOptional) && this.isValidSubstitute(componentIdentifier.getVersion(), this.revisionIsOptional) && this.isValidSubstitute(artifactName.getName(), this.artifactIsOptional) && this.isValidSubstitute(artifactName.getClassifier(), this.classifierIsOptional) && this.isValidSubstitute(artifactName.getExtension(), this.extensionIsOptional) && this.isValidSubstitute(artifactName.getType(), this.typeIsOptional);
    }

    private boolean isValidSubstitute(@Nullable String candidate, boolean optional) {
        if (Strings.isNullOrEmpty(candidate)) {
            return optional;
        }
        return !candidate.startsWith("${");
    }

    private boolean isOptionalToken(String ... tokenVariants) {
        String patternString = this.pattern.getPath();
        int tokenIndex = -1;
        for (String token : tokenVariants) {
            tokenIndex = patternString.indexOf("[" + token + "]");
            if (tokenIndex != -1) break;
        }
        if (tokenIndex == -1) {
            return true;
        }
        int optionalOpen = 0;
        for (int i = 0; i < tokenIndex; ++i) {
            char nextChar = patternString.charAt(i);
            if (nextChar == '(') {
                ++optionalOpen;
                continue;
            }
            if (nextChar != ')') continue;
            optionalOpen = Math.max(0, optionalOpen - 1);
        }
        return optionalOpen > 0;
    }
}

