/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.transform.ConsumerVariantMatchResult;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.internal.Pair;
import org.gradle.internal.component.AmbiguousVariantSelectionException;
import org.gradle.internal.component.VariantSelectionException;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.logging.text.TreeFormatter;

public class AmbiguousTransformException
extends VariantSelectionException {
    public AmbiguousTransformException(String producerDisplayName, AttributeContainerInternal requested, List<Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant>> candidates) {
        super(AmbiguousTransformException.format(producerDisplayName, requested, candidates));
    }

    private static String format(String producerDisplayName, AttributeContainerInternal requested, List<Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant>> candidates) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("Found multiple transforms that can produce a variant of " + producerDisplayName + " with requested attributes");
        AmbiguousVariantSelectionException.formatAttributes(formatter, requested);
        formatter.node("Found the following transforms");
        Map variantToTransforms = candidates.stream().collect(Collectors.toMap(Pair::getLeft, candidate -> Lists.newArrayList((ConsumerVariantMatchResult.ConsumerVariant)candidate.getRight()), (orig, add) -> {
            orig.addAll(add);
            return orig;
        }, LinkedHashMap::new));
        formatter.startChildren();
        for (Map.Entry entry : variantToTransforms.entrySet()) {
            formatter.node("From '" + ((ResolvedVariant)entry.getKey()).asDescribable().getDisplayName() + "'");
            formatter.startChildren();
            formatter.node("With source attributes");
            AmbiguousVariantSelectionException.formatAttributes(formatter, ((ResolvedVariant)entry.getKey()).getAttributes());
            formatter.node("Candidate transform(s)");
            formatter.startChildren();
            for (ConsumerVariantMatchResult.ConsumerVariant transform : (List)entry.getValue()) {
                formatter.node("Transform '" + transform.transformation.getDisplayName() + "' producing attributes:");
                AmbiguousVariantSelectionException.formatAttributes(formatter, transform.attributes);
            }
            formatter.endChildren();
            formatter.endChildren();
        }
        formatter.endChildren();
        return formatter.toString();
    }
}

