/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.ImmutableDirectoryTree;
import org.gradle.api.internal.file.collections.DirectoryTrees;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.file.collections.GeneratedFiles;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.FileUtils;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableCollection;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.nativeintegration.services.FileSystems;

@ThreadSafe
public class FileSystemSubset {
    private final ImmutableCollection<File> files;
    private final ImmutableCollection<ImmutableDirectoryTree> trees;

    public static Builder builder() {
        return new Builder();
    }

    public static FileSystemSubset of(FileCollectionInternal fileCollection) {
        Builder subsetBuilder = FileSystemSubset.builder();
        fileCollection.visitStructure(subsetBuilder);
        return subsetBuilder.build();
    }

    public FileSystemSubset(ImmutableCollection<File> files, ImmutableCollection<ImmutableDirectoryTree> trees) {
        this.files = files;
        this.trees = trees;
    }

    public Iterable<? extends File> getRoots() {
        return FileUtils.calculateRoots(Iterables.concat(this.files, Iterables.transform(this.trees, input -> input.getDir())));
    }

    public FileSystemSubset unfiltered() {
        return new FileSystemSubset(ImmutableList.copyOf(this.getRoots()), ImmutableList.of());
    }

    public boolean isEmpty() {
        return this.files.isEmpty() && this.trees.isEmpty();
    }

    public boolean contains(File file) {
        File absoluteFile = file.getAbsoluteFile();
        for (File file2 : this.files) {
            if (!FileUtils.doesPathStartWith(file.getAbsolutePath(), file2.getPath())) continue;
            return true;
        }
        for (DirectoryTree directoryTree : this.trees) {
            if (!directoryTree.getDir().getAbsoluteFile().equals(absoluteFile) && !DirectoryTrees.contains(FileSystems.getDefault(), directoryTree, absoluteFile)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Files: ").append(this.files);
        sb.append(" Trees: ").append(this.trees);
        return sb.toString();
    }

    @ThreadSafe
    public static class Builder
    implements FileCollectionStructureVisitor {
        private final ImmutableSet.Builder<File> files = ImmutableSet.builder();
        private final ImmutableSet.Builder<ImmutableDirectoryTree> trees = ImmutableSet.builder();
        private final Lock lock = new ReentrantLock();

        private Builder() {
        }

        @Override
        public FileCollectionStructureVisitor.VisitType prepareForVisit(FileCollectionInternal.Source source) {
            if (source instanceof GeneratedFiles) {
                return FileCollectionStructureVisitor.VisitType.NoContents;
            }
            return FileCollectionStructureVisitor.VisitType.Spec;
        }

        @Override
        public void visitCollection(FileCollectionInternal.Source source, Iterable<File> contents) {
            this.addFiles(contents);
        }

        @Override
        public void visitGenericFileTree(FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
            this.addFiles(fileTree);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitFileTree(File root, PatternSet patterns, FileTreeInternal fileTree) {
            this.lock.lock();
            try {
                this.trees.add((Object)ImmutableDirectoryTree.of(root, patterns));
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitFileTreeBackedByFile(File file, FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
            this.lock.lock();
            try {
                this.files.add((Object)file.getAbsoluteFile());
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addFiles(Iterable<File> contents) {
            this.lock.lock();
            try {
                for (File file : contents) {
                    this.files.add((Object)file.getAbsoluteFile());
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public Builder add(FileSystemSubset fileSystemSubset) {
            this.lock.lock();
            try {
                this.files.addAll((Iterable)fileSystemSubset.files);
                this.trees.addAll((Iterable)fileSystemSubset.trees);
                Builder builder = this;
                return builder;
            }
            finally {
                this.lock.unlock();
            }
        }

        public Builder add(File file) {
            this.lock.lock();
            try {
                this.files.add((Object)file.getAbsoluteFile());
                Builder builder = this;
                return builder;
            }
            finally {
                this.lock.unlock();
            }
        }

        public Builder add(DirectoryTree directoryTree) {
            this.lock.lock();
            try {
                this.trees.add((Object)ImmutableDirectoryTree.of(directoryTree));
                Builder builder = this;
                return builder;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder add(File dir2, PatternSet patternSet) {
            this.lock.lock();
            try {
                this.trees.add((Object)ImmutableDirectoryTree.of(dir2, patternSet));
                Builder builder = this;
                return builder;
            }
            finally {
                this.lock.unlock();
            }
        }

        public FileSystemSubset build() {
            this.lock.lock();
            try {
                FileSystemSubset fileSystemSubset = new FileSystemSubset(this.files.build(), this.trees.build());
                return fileSystemSubset;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

