/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import groovy.lang.Closure;
import java.io.File;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.FileTreeAdapter;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.internal.file.PathToFileResolver;

public class DefaultConfigurableFileTree
extends CompositeFileTree
implements ConfigurableFileTree {
    private Object dir;
    private final PatternSet patternSet;
    private final PathToFileResolver resolver;
    private final DefaultTaskDependency buildDependency;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;

    public DefaultConfigurableFileTree(PathToFileResolver resolver, Factory<PatternSet> patternSetFactory, TaskDependencyFactory taskDependencyFactory, DirectoryFileTreeFactory directoryFileTreeFactory) {
        this.resolver = resolver;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.patternSet = patternSetFactory.create();
        this.buildDependency = taskDependencyFactory.configurableDependency();
    }

    @Override
    public PatternSet getPatterns() {
        return this.patternSet;
    }

    @Override
    public DefaultConfigurableFileTree setDir(Object dir2) {
        this.from(dir2);
        return this;
    }

    @Override
    public File getDir() {
        if (this.dir == null) {
            throw new InvalidUserDataException("A base directory must be specified in the task or via a method argument!");
        }
        return this.resolver.resolve(this.dir);
    }

    @Override
    public DefaultConfigurableFileTree from(Object dir2) {
        this.dir = dir2;
        return this;
    }

    @Override
    public String getDisplayName() {
        return "directory '" + this.dir + "'";
    }

    @Override
    public Set<String> getIncludes() {
        return this.patternSet.getIncludes();
    }

    @Override
    public DefaultConfigurableFileTree setIncludes(Iterable<String> includes) {
        this.patternSet.setIncludes((Iterable)includes);
        return this;
    }

    @Override
    public Set<String> getExcludes() {
        return this.patternSet.getExcludes();
    }

    @Override
    public DefaultConfigurableFileTree setExcludes(Iterable<String> excludes) {
        this.patternSet.setExcludes((Iterable)excludes);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree include(String ... includes) {
        this.patternSet.include(includes);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree include(Iterable<String> includes) {
        this.patternSet.include((Iterable)includes);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree include(Closure includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree include(Spec<FileTreeElement> includeSpec) {
        this.patternSet.include((Spec)includeSpec);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree exclude(String ... excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree exclude(Iterable<String> excludes) {
        this.patternSet.exclude((Iterable)excludes);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree exclude(Spec<FileTreeElement> excludeSpec) {
        this.patternSet.exclude((Spec)excludeSpec);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree exclude(Closure excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    @Override
    protected void visitChildren(Consumer<FileCollectionInternal> visitor) {
        File dir2 = this.getDir();
        visitor.accept(new FileTreeAdapter(this.directoryFileTreeFactory.create(dir2, this.patternSet), this.patternSetFactory));
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        context.add(this.buildDependency);
    }

    @Override
    public ConfigurableFileTree builtBy(Object ... tasks) {
        this.buildDependency.add(tasks);
        return this;
    }

    @Override
    public Set<Object> getBuiltBy() {
        return this.buildDependency.getMutableValues();
    }

    @Override
    public ConfigurableFileTree setBuiltBy(Iterable<?> tasks) {
        this.buildDependency.setValues(tasks);
        return this;
    }
}

