/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import java.io.File;
import java.io.IOException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.file.copy.ZipCompressor;
import org.gradle.internal.IoActions;
import org.gradle.internal.impldep.org.apache.tools.zip.Zip64Mode;
import org.gradle.internal.impldep.org.apache.tools.zip.ZipOutputStream;

public class DefaultZipCompressor
implements ZipCompressor {
    private final int entryCompressionMethod;
    private final Zip64Mode zip64Mode;

    public DefaultZipCompressor(boolean allowZip64Mode, int entryCompressionMethod) {
        this.entryCompressionMethod = entryCompressionMethod;
        this.zip64Mode = allowZip64Mode ? Zip64Mode.AsNeeded : Zip64Mode.Never;
    }

    @Override
    public ZipOutputStream createArchiveOutputStream(File destination) throws IOException {
        ZipOutputStream outStream = new ZipOutputStream(destination);
        try {
            outStream.setUseZip64(this.zip64Mode);
            outStream.setMethod(this.entryCompressionMethod);
            return outStream;
        }
        catch (Exception e) {
            IoActions.closeQuietly(outStream);
            String message2 = String.format("Unable to create ZIP output stream for file %s.", destination);
            throw new UncheckedIOException(message2, e);
        }
    }
}

