/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.antbuilder;

import groovy.lang.Closure;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Vector;
import org.gradle.api.Action;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.classloading.GroovySystemLoader;
import org.gradle.api.internal.classloading.GroovySystemLoaderFactory;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.api.internal.project.antbuilder.AntBuilderDelegate;
import org.gradle.api.internal.project.antbuilder.CachedClassLoader;
import org.gradle.api.internal.project.antbuilder.ClassPathToClassLoaderCache;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.CachingClassLoader;
import org.gradle.internal.classloader.ClassLoaderFactory;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.MultiParentClassLoader;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.jvm.Jvm;
import org.gradle.util.ClosureBackedAction;

public class DefaultIsolatedAntBuilder
implements IsolatedAntBuilder,
Stoppable {
    private static final Logger LOG = Logging.getLogger(DefaultIsolatedAntBuilder.class);
    private final ClassLoader antLoader;
    private final ClassLoader baseAntLoader;
    private final ClassPath libClasspath;
    private final ClassLoader antAdapterLoader;
    private final ClassPathRegistry classPathRegistry;
    private final ClassLoaderFactory classLoaderFactory;
    private final ModuleRegistry moduleRegistry;
    private final ClassPathToClassLoaderCache classLoaderCache;
    private final GroovySystemLoader gradleApiGroovyLoader;
    private final GroovySystemLoader antAdapterGroovyLoader;

    public DefaultIsolatedAntBuilder(ClassPathRegistry classPathRegistry, ClassLoaderFactory classLoaderFactory, ModuleRegistry moduleRegistry) {
        this.classPathRegistry = classPathRegistry;
        this.classLoaderFactory = classLoaderFactory;
        this.moduleRegistry = moduleRegistry;
        this.libClasspath = ClassPath.EMPTY;
        GroovySystemLoaderFactory groovySystemLoaderFactory = new GroovySystemLoaderFactory();
        this.classLoaderCache = new ClassPathToClassLoaderCache(groovySystemLoaderFactory);
        ArrayList<File> antClasspath = Lists.newArrayList(classPathRegistry.getClassPath("ANT").getAsFiles());
        File toolsJar = Jvm.current().getToolsJar();
        if (toolsJar != null) {
            antClasspath.add(toolsJar);
        }
        this.antLoader = classLoaderFactory.createIsolatedClassLoader("isolated-ant-loader", DefaultClassPath.of(antClasspath));
        FilteringClassLoader.Spec loggingLoaderSpec = new FilteringClassLoader.Spec();
        loggingLoaderSpec.allowPackage("org.slf4j");
        loggingLoaderSpec.allowPackage("org.apache.commons.logging");
        loggingLoaderSpec.allowPackage("org.apache.log4j");
        loggingLoaderSpec.allowClass(Logger.class);
        loggingLoaderSpec.allowClass(LogLevel.class);
        FilteringClassLoader loggingLoader = new FilteringClassLoader(this.getClass().getClassLoader(), loggingLoaderSpec);
        this.baseAntLoader = new CachingClassLoader(new MultiParentClassLoader(this.antLoader, loggingLoader));
        ClassPath gradleCoreUrls = moduleRegistry.getModule("gradle-core-api").getImplementationClasspath();
        gradleCoreUrls = gradleCoreUrls.plus(moduleRegistry.getModule("gradle-core").getImplementationClasspath());
        gradleCoreUrls = gradleCoreUrls.plus(moduleRegistry.getModule("gradle-logging").getImplementationClasspath());
        gradleCoreUrls = gradleCoreUrls.plus(moduleRegistry.getExternalModule("groovy-all").getClasspath());
        gradleCoreUrls = gradleCoreUrls.plus(moduleRegistry.getModule("gradle-base-services").getImplementationClasspath());
        this.antAdapterLoader = new VisitableURLClassLoader("gradle-core-loader", this.baseAntLoader, gradleCoreUrls);
        this.gradleApiGroovyLoader = groovySystemLoaderFactory.forClassLoader(this.getClass().getClassLoader());
        this.antAdapterGroovyLoader = groovySystemLoaderFactory.forClassLoader(this.antAdapterLoader);
    }

    protected DefaultIsolatedAntBuilder(DefaultIsolatedAntBuilder copy, Iterable<File> libClasspath) {
        this.classPathRegistry = copy.classPathRegistry;
        this.classLoaderFactory = copy.classLoaderFactory;
        this.moduleRegistry = copy.moduleRegistry;
        this.antLoader = copy.antLoader;
        this.baseAntLoader = copy.baseAntLoader;
        this.antAdapterLoader = copy.antAdapterLoader;
        this.libClasspath = DefaultClassPath.of(libClasspath);
        this.gradleApiGroovyLoader = copy.gradleApiGroovyLoader;
        this.antAdapterGroovyLoader = copy.antAdapterGroovyLoader;
        this.classLoaderCache = copy.classLoaderCache;
    }

    public ClassPathToClassLoaderCache getClassLoaderCache() {
        return this.classLoaderCache;
    }

    @Override
    public IsolatedAntBuilder withClasspath(Iterable<File> classpath) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Forking a new isolated ant builder for classpath : {}", (Object)classpath);
        }
        return new DefaultIsolatedAntBuilder(this, classpath);
    }

    @Override
    public void execute(final Closure antClosure) {
        this.classLoaderCache.withCachedClassLoader(this.libClasspath, this.gradleApiGroovyLoader, this.antAdapterGroovyLoader, (Factory<? extends ClassLoader>)new Factory<ClassLoader>(){

            @Override
            public ClassLoader create() {
                return new VisitableURLClassLoader("ant-lib-loader", DefaultIsolatedAntBuilder.this.baseAntLoader, DefaultIsolatedAntBuilder.this.libClasspath);
            }
        }, (Action<? super CachedClassLoader>)new Action<CachedClassLoader>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(CachedClassLoader cachedClassLoader) {
                ClassLoader classLoader = cachedClassLoader.getClassLoader();
                Object antBuilder = DefaultIsolatedAntBuilder.this.newInstanceOf("org.gradle.api.internal.project.ant.BasicAntBuilder");
                Object antLogger = DefaultIsolatedAntBuilder.this.newInstanceOf("org.gradle.api.internal.project.ant.AntLoggingAdapter");
                ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(classLoader);
                try {
                    DefaultIsolatedAntBuilder.this.configureAntBuilder(antBuilder, antLogger);
                    AntBuilderDelegate delegate = new AntBuilderDelegate(antBuilder, classLoader);
                    ClosureBackedAction.execute(delegate, antClosure);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalLoader);
                    DefaultIsolatedAntBuilder.this.disposeBuilder(antBuilder, antLogger);
                }
            }
        });
    }

    private Object newInstanceOf(String className) {
        try {
            return this.antAdapterLoader.loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    private Object getProject(Object antBuilder) throws Exception {
        return antBuilder.getClass().getMethod("getProject", new Class[0]).invoke(antBuilder, new Object[0]);
    }

    protected void configureAntBuilder(Object antBuilder, Object antLogger) {
        try {
            Object project = this.getProject(antBuilder);
            Class<?> projectClass = project.getClass();
            ClassLoader cl = projectClass.getClassLoader();
            Class<?> buildListenerClass = cl.loadClass("org.apache.tools.ant.BuildListener");
            Method addBuildListener = projectClass.getDeclaredMethod("addBuildListener", buildListenerClass);
            Method removeBuildListener = projectClass.getDeclaredMethod("removeBuildListener", buildListenerClass);
            Method getBuildListeners = projectClass.getDeclaredMethod("getBuildListeners", new Class[0]);
            Vector listeners = (Vector)getBuildListeners.invoke(project, new Object[0]);
            removeBuildListener.invoke(project, listeners.get(0));
            addBuildListener.invoke(project, antLogger);
        }
        catch (Exception ex) {
            throw UncheckedException.throwAsUncheckedException(ex);
        }
    }

    protected void disposeBuilder(Object antBuilder, Object antLogger) {
        try {
            Object project = this.getProject(antBuilder);
            Class<?> projectClass = project.getClass();
            ClassLoader cl = projectClass.getClassLoader();
            Class<?> buildListenerClass = cl.loadClass("org.apache.tools.ant.BuildListener");
            Method removeBuildListener = projectClass.getDeclaredMethod("removeBuildListener", buildListenerClass);
            removeBuildListener.invoke(project, antLogger);
            antBuilder.getClass().getDeclaredMethod("close", new Class[0]).invoke(antBuilder, new Object[0]);
        }
        catch (Exception ex) {
            throw UncheckedException.throwAsUncheckedException(ex);
        }
    }

    @Override
    public void stop() {
        this.classLoaderCache.stop();
        this.gradleApiGroovyLoader.discardTypesFrom(this.antAdapterLoader);
        this.gradleApiGroovyLoader.discardTypesFrom(this.antLoader);
        this.antAdapterGroovyLoader.shutdown();
        ClassLoaderUtils.tryClose(this.antAdapterLoader);
    }
}

