/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resources;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.resources.ResourceException;
import org.gradle.api.resources.internal.TextResourceInternal;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.impldep.com.google.common.io.FileWriteMode;
import org.gradle.internal.impldep.com.google.common.io.Files;

public class StringBackedTextResource
implements TextResourceInternal {
    private final TemporaryFileProvider tempFileProvider;
    private final String string;

    public StringBackedTextResource(TemporaryFileProvider tempFileProvider, String string2) {
        this.tempFileProvider = tempFileProvider;
        this.string = string2;
    }

    @Override
    public String getDisplayName() {
        return "text resource";
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public String asString() {
        return this.string;
    }

    @Override
    public Reader asReader() {
        return new StringReader(this.string);
    }

    @Override
    public File asFile(String charset) {
        File file = this.tempFileProvider.createTemporaryFile("string", ".txt", "resource");
        try {
            Files.asCharSink(file, Charset.forName(charset), new FileWriteMode[0]).write(this.string);
        }
        catch (IOException e) {
            throw new ResourceException("Could not write " + this.getDisplayName() + " content to " + file + ".", e);
        }
        return file;
    }

    @Override
    public File asFile() {
        return this.asFile(Charset.defaultCharset().name());
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return TaskDependencyInternal.EMPTY;
    }

    @Override
    public Object getInputProperties() {
        return this.string;
    }

    @Override
    public FileCollection getInputFiles() {
        return null;
    }
}

