/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.api.tasks.javadoc.Groovydoc;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableCollection;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.util.VersionNumber;

public class AntGroovydoc {
    private final IsolatedAntBuilder ant;

    public AntGroovydoc(IsolatedAntBuilder ant, ClassPathRegistry ignored) {
        this.ant = ant;
    }

    public void execute(FileCollection source, File destDir, boolean use, boolean noTimestamp, boolean noVersionStamp, String windowTitle, String docTitle, String header, String footer, String overview, boolean includePrivate, Set<Groovydoc.Link> links, Iterable<File> groovyClasspath, Iterable<File> classpath, File tmpDir, FileSystemOperations fsOperations) {
        fsOperations.delete(spec -> spec.delete(tmpDir));
        fsOperations.copy(spec -> spec.from(source).into(tmpDir));
        ImmutableCollection combinedClasspath = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(classpath)).addAll(groovyClasspath)).build();
        VersionNumber version = VersionNumber.parse(this.getGroovyVersion((List<File>)((Object)combinedClasspath)));
        LinkedHashMap<String, Object> args = Maps.newLinkedHashMap();
        args.put("sourcepath", tmpDir.toString());
        args.put("destdir", destDir);
        args.put("use", use);
        if (this.isAtLeast(version, "2.4.6")) {
            args.put("noTimestamp", noTimestamp);
            args.put("noVersionStamp", noVersionStamp);
        }
        args.put("private", includePrivate);
        AntGroovydoc.putIfNotNull(args, "windowtitle", windowTitle);
        AntGroovydoc.putIfNotNull(args, "doctitle", docTitle);
        AntGroovydoc.putIfNotNull(args, "header", header);
        AntGroovydoc.putIfNotNull(args, "footer", footer);
        if (overview != null) {
            args.put("overview", overview);
        }
        this.invokeGroovydoc(links, (List<File>)((Object)combinedClasspath), args);
    }

    private boolean isAtLeast(VersionNumber version, String versionString) {
        return version.compareTo(VersionNumber.parse(versionString)) >= 0;
    }

    private String getGroovyVersion(List<File> combinedClasspath) {
        String tempPath;
        File temp;
        try {
            temp = File.createTempFile("temp", "");
            String p = temp.getCanonicalPath();
            tempPath = File.separatorChar == '/' ? p : p.replace(File.separatorChar, '/');
            temp.deleteOnExit();
        }
        catch (IOException e) {
            throw new GradleException("Unable to create temp file needed for Groovydoc", e);
        }
        this.ant.withClasspath(combinedClasspath).execute((Closure)new Closure<Object>((Object)this, (Object)this){

            public Object doCall(Object it) {
                GroovyObjectSupport antBuilder = (GroovyObjectSupport)it;
                antBuilder.invokeMethod("taskdef", ImmutableMap.of("name", "groovy", "classname", "org.codehaus.groovy.ant.Groovy"));
                antBuilder.invokeMethod("groovy", (Object)new Object[]{"new File('" + tempPath + "').text = GroovySystem.version"});
                return null;
            }
        });
        try {
            return Files.asCharSource(temp, Charset.defaultCharset()).read().trim();
        }
        catch (IOException e) {
            throw new GradleException("Unable to find Groovy version needed for Groovydoc", e);
        }
    }

    private void invokeGroovydoc(final Set<Groovydoc.Link> links, List<File> combinedClasspath, final Map<String, Object> args) {
        this.ant.withClasspath(combinedClasspath).execute((Closure)new Closure<Object>((Object)this, (Object)this){

            public Object doCall(Object it) {
                final GroovyObjectSupport antBuilder = (GroovyObjectSupport)it;
                antBuilder.invokeMethod("taskdef", ImmutableMap.of("name", "groovydoc", "classname", "org.codehaus.groovy.ant.Groovydoc"));
                antBuilder.invokeMethod("groovydoc", (Object)new Object[]{args, new Closure<Object>((Object)this, (Object)this){

                    public Object doCall(Object ignore) {
                        for (Groovydoc.Link link : links) {
                            antBuilder.invokeMethod("link", (Object)new Object[]{ImmutableMap.of("packages", Joiner.on(",").join(link.getPackages()), "href", link.getUrl())});
                        }
                        return null;
                    }
                }});
                return null;
            }
        });
    }

    private static void putIfNotNull(Map<String, Object> map, String key, Object value) {
        if (value != null) {
            map.put(key, value);
        }
    }
}

