/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.jvm.ClassDirectoryBinaryNamingScheme;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.tasks.DefaultSourceSetOutput;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GUtil;

public abstract class DefaultSourceSet
implements SourceSet {
    private final String name;
    private final String baseName;
    private FileCollection compileClasspath;
    private FileCollection annotationProcessorPath;
    private FileCollection runtimeClasspath;
    private final SourceDirectorySet javaSource;
    private final SourceDirectorySet allJavaSource;
    private final SourceDirectorySet resources;
    private final String displayName;
    private final SourceDirectorySet allSource;
    private final ClassDirectoryBinaryNamingScheme namingScheme;
    private DefaultSourceSetOutput output;

    public DefaultSourceSet(String name, ObjectFactory objectFactory) {
        this.name = name;
        this.baseName = name.equals("main") ? "" : GUtil.toCamelCase(name);
        this.displayName = GUtil.toWords(this.name);
        this.namingScheme = new ClassDirectoryBinaryNamingScheme(name);
        String javaSrcDisplayName = this.displayName + " Java source";
        this.javaSource = objectFactory.sourceDirectorySet("java", javaSrcDisplayName);
        this.javaSource.getFilter().include("**/*.java");
        this.allJavaSource = objectFactory.sourceDirectorySet("alljava", javaSrcDisplayName);
        this.allJavaSource.getFilter().include("**/*.java");
        this.allJavaSource.source(this.javaSource);
        String resourcesDisplayName = this.displayName + " resources";
        this.resources = objectFactory.sourceDirectorySet("resources", resourcesDisplayName);
        SourceDirectorySet javaSourceFiles = this.javaSource;
        this.resources.getFilter().exclude(SerializableLambdas.spec(element -> javaSourceFiles.contains(element.getFile())));
        String allSourceDisplayName = this.displayName + " source";
        this.allSource = objectFactory.sourceDirectorySet("allsource", allSourceDisplayName);
        this.allSource.source(this.resources);
        this.allSource.source(this.javaSource);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "source set '" + this.getDisplayName() + "'";
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getClassesTaskName() {
        return this.getTaskName(null, "classes");
    }

    @Override
    public String getCompileTaskName(String language) {
        return this.getTaskName("compile", language);
    }

    @Override
    public String getCompileJavaTaskName() {
        return this.getCompileTaskName("java");
    }

    @Override
    public String getProcessResourcesTaskName() {
        return this.getTaskName("process", "resources");
    }

    @Override
    public String getJavadocTaskName() {
        return this.getTaskName(null, "javadoc");
    }

    @Override
    public String getJarTaskName() {
        return this.getTaskName(null, "jar");
    }

    @Override
    public String getJavadocJarTaskName() {
        return this.getTaskName(null, "javadocJar");
    }

    @Override
    public String getSourcesJarTaskName() {
        return this.getTaskName(null, "sourcesJar");
    }

    @Override
    public String getTaskName(@Nullable String verb, @Nullable String target) {
        return this.namingScheme.getTaskName(verb, target);
    }

    private String getTaskBaseName() {
        return this.baseName;
    }

    @Override
    public String getCompileConfigurationName() {
        return this.configurationNameOf("compile");
    }

    private String configurationNameOf(String baseName) {
        return StringUtils.uncapitalize(this.getTaskBaseName() + StringUtils.capitalize(baseName));
    }

    @Override
    public String getRuntimeConfigurationName() {
        return this.configurationNameOf("runtime");
    }

    @Override
    public String getCompileOnlyConfigurationName() {
        return this.configurationNameOf("compileOnly");
    }

    @Override
    public String getCompileOnlyApiConfigurationName() {
        return this.configurationNameOf("compileOnlyApi");
    }

    @Override
    public String getCompileClasspathConfigurationName() {
        return this.configurationNameOf("compileClasspath");
    }

    @Override
    public String getAnnotationProcessorConfigurationName() {
        return this.configurationNameOf("annotationProcessor");
    }

    @Override
    public String getApiConfigurationName() {
        return this.configurationNameOf("api");
    }

    @Override
    public String getImplementationConfigurationName() {
        return this.configurationNameOf("implementation");
    }

    @Override
    public String getApiElementsConfigurationName() {
        return this.configurationNameOf("apiElements");
    }

    @Override
    public String getRuntimeOnlyConfigurationName() {
        return this.configurationNameOf("runtimeOnly");
    }

    @Override
    public String getRuntimeClasspathConfigurationName() {
        return this.configurationNameOf("runtimeClasspath");
    }

    @Override
    public String getRuntimeElementsConfigurationName() {
        return this.configurationNameOf("runtimeElements");
    }

    @Override
    public String getJavadocElementsConfigurationName() {
        return this.configurationNameOf("javadocElements");
    }

    @Override
    public String getSourcesElementsConfigurationName() {
        return this.configurationNameOf("sourcesElements");
    }

    @Override
    public SourceSetOutput getOutput() {
        return this.output;
    }

    public void setClasses(DefaultSourceSetOutput classes) {
        this.output = classes;
    }

    @Override
    public SourceSet compiledBy(Object ... taskPaths) {
        this.output.builtBy(taskPaths);
        return this;
    }

    @Override
    public FileCollection getCompileClasspath() {
        return this.compileClasspath;
    }

    @Override
    public FileCollection getAnnotationProcessorPath() {
        return this.annotationProcessorPath;
    }

    @Override
    public FileCollection getRuntimeClasspath() {
        return this.runtimeClasspath;
    }

    @Override
    public void setCompileClasspath(FileCollection classpath) {
        this.compileClasspath = classpath;
    }

    @Override
    public void setAnnotationProcessorPath(FileCollection annotationProcessorPath) {
        this.annotationProcessorPath = annotationProcessorPath;
    }

    @Override
    public void setRuntimeClasspath(FileCollection classpath) {
        this.runtimeClasspath = classpath;
    }

    @Override
    public SourceDirectorySet getJava() {
        return this.javaSource;
    }

    @Override
    public SourceSet java(@Nullable Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getJava());
        return this;
    }

    @Override
    public SourceSet java(Action<? super SourceDirectorySet> configureAction) {
        configureAction.execute(this.getJava());
        return this;
    }

    @Override
    public SourceDirectorySet getAllJava() {
        return this.allJavaSource;
    }

    @Override
    public SourceDirectorySet getResources() {
        return this.resources;
    }

    @Override
    public SourceSet resources(@Nullable Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getResources());
        return this;
    }

    @Override
    public SourceSet resources(Action<? super SourceDirectorySet> configureAction) {
        configureAction.execute(this.getResources());
        return this;
    }

    @Override
    public SourceDirectorySet getAllSource() {
        return this.allSource;
    }
}

