/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.logging.text.TreeFormatter;

public class DefaultSourceSetOutput
extends CompositeFileCollection
implements SourceSetOutput {
    private final ConfigurableFileCollection outputDirectories;
    private Object resourcesDir;
    private final ConfigurableFileCollection classesDirs;
    private final ConfigurableFileCollection dirs;
    private final ConfigurableFileCollection generatedSourcesDirs;
    private final FileResolver fileResolver;
    private final DefaultTaskDependency compileTasks;

    public DefaultSourceSetOutput(String sourceSetDisplayName, FileResolver fileResolver, FileCollectionFactory fileCollectionFactory) {
        this.fileResolver = fileResolver;
        this.classesDirs = fileCollectionFactory.configurableFiles(sourceSetDisplayName + " classesDirs");
        this.classesDirs.builtBy(this);
        this.outputDirectories = fileCollectionFactory.configurableFiles(sourceSetDisplayName + " classes");
        this.outputDirectories.from(this.classesDirs, this::getResourcesDir);
        this.dirs = fileCollectionFactory.configurableFiles(sourceSetDisplayName + " dirs");
        this.generatedSourcesDirs = fileCollectionFactory.configurableFiles(sourceSetDisplayName + " generatedSourcesDirs");
        this.compileTasks = new DefaultTaskDependency();
    }

    @Override
    protected void visitChildren(Consumer<FileCollectionInternal> visitor) {
        visitor.accept((FileCollectionInternal)((Object)this.outputDirectories));
    }

    @Override
    public String getDisplayName() {
        return this.outputDirectories.toString();
    }

    @Override
    protected void appendContents(TreeFormatter formatter) {
        formatter.node("source set: " + this.outputDirectories.toString());
        formatter.node("output directories");
        formatter.startChildren();
        ((FileCollectionInternal)((Object)this.outputDirectories)).describeContents(formatter);
        formatter.endChildren();
    }

    @Override
    public ConfigurableFileCollection getClassesDirs() {
        return this.classesDirs;
    }

    public void addClassesDir(Provider<Directory> directory) {
        this.classesDirs.from(directory);
    }

    @Override
    @Nullable
    public File getResourcesDir() {
        if (this.resourcesDir == null) {
            return null;
        }
        return this.fileResolver.resolve(this.resourcesDir);
    }

    @Override
    public void setResourcesDir(File resourcesDir) {
        this.resourcesDir = resourcesDir;
    }

    @Override
    public void setResourcesDir(Object resourcesDir) {
        this.resourcesDir = resourcesDir;
    }

    public void builtBy(Object ... taskPaths) {
        this.outputDirectories.builtBy(taskPaths);
    }

    @Override
    public void dir(Object dir2) {
        this.dir(Collections.emptyMap(), dir2);
    }

    @Override
    public void dir(Map<String, Object> options, Object dir2) {
        this.dirs.from(dir2);
        this.outputDirectories.from(dir2);
        Object builtBy = options.get("builtBy");
        if (builtBy != null) {
            this.builtBy(builtBy);
            this.dirs.builtBy(builtBy);
        }
    }

    @Override
    public FileCollection getDirs() {
        return this.dirs;
    }

    @Override
    public ConfigurableFileCollection getGeneratedSourcesDirs() {
        return this.generatedSourcesDirs;
    }

    public void registerClassesContributor(TaskProvider<?> task) {
        this.compileTasks.add(task);
    }

    public TaskDependency getClassesContributors() {
        return this.compileTasks;
    }
}

