/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.MinimalJavaCompileOptions;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.tasks.StaleOutputCleaner;

public class CleaningJavaCompiler<T extends JavaCompileSpec>
implements Compiler<T> {
    private final Compiler<T> compiler;
    private final TaskOutputsInternal taskOutputs;
    private final Deleter deleter;

    public CleaningJavaCompiler(Compiler<T> compiler, TaskOutputsInternal taskOutputs, Deleter deleter) {
        this.compiler = compiler;
        this.taskOutputs = taskOutputs;
        this.deleter = deleter;
    }

    @Override
    public WorkResult execute(T spec) {
        ImmutableSet.Builder<File> outputDirs = ImmutableSet.builderWithExpectedSize(3);
        MinimalJavaCompileOptions compileOptions = spec.getCompileOptions();
        this.addDirectoryIfNotNull(outputDirs, spec.getDestinationDir());
        this.addDirectoryIfNotNull(outputDirs, compileOptions.getAnnotationProcessorGeneratedSourcesDirectory());
        this.addDirectoryIfNotNull(outputDirs, compileOptions.getHeaderOutputDirectory());
        boolean cleanedOutputs = StaleOutputCleaner.cleanOutputs(this.deleter, this.taskOutputs.getPreviousOutputFiles(), (ImmutableSet<File>)outputDirs.build());
        Compiler<T> compiler = this.getCompiler();
        return compiler.execute(spec).or(WorkResults.didWork(cleanedOutputs));
    }

    private void addDirectoryIfNotNull(ImmutableSet.Builder<File> outputDirs, @Nullable File dir2) {
        if (dir2 != null) {
            outputDirs.add((Object)dir2);
        }
    }

    public Compiler<T> getCompiler() {
        return this.compiler;
    }
}

