/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.gradle.api.internal.tasks.compile.CompilationFailedException;
import org.gradle.api.internal.tasks.compile.JavaCompilerArgumentsBuilder;
import org.gradle.api.internal.tasks.scala.AnalysisStoreProvider;
import org.gradle.api.internal.tasks.scala.SbtLoggerAdapter;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.internal.tasks.scala.ZincScalaCompilerArgumentsGenerator;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.cache.internal.MapBackedCache;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.util.GFileUtils;
import sbt.internal.inc.Analysis;
import sbt.internal.inc.ExternalLookup;
import sbt.internal.inc.IncrementalCompilerImpl;
import sbt.internal.inc.Locate;
import sbt.internal.inc.LoggedReporter;
import sbt.internal.inc.ScalaInstance;
import sbt.internal.inc.Stamper;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.JavaConverters;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.Set;
import xsbti.CompileFailed;
import xsbti.Reporter;
import xsbti.T2;
import xsbti.compile.AnalysisContents;
import xsbti.compile.AnalysisStore;
import xsbti.compile.Changes;
import xsbti.compile.ClassFileManager;
import xsbti.compile.ClasspathOptionsUtil;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.CompileOptions;
import xsbti.compile.CompileResult;
import xsbti.compile.CompilerCache;
import xsbti.compile.Compilers;
import xsbti.compile.DefinesClass;
import xsbti.compile.ExternalHooks;
import xsbti.compile.FileHash;
import xsbti.compile.IncOptions;
import xsbti.compile.Inputs;
import xsbti.compile.MiniSetup;
import xsbti.compile.PerClasspathEntryLookup;
import xsbti.compile.PreviousResult;
import xsbti.compile.ScalaCompiler;
import xsbti.compile.Setup;
import xsbti.compile.TransactionalManagerType;
import xsbti.compile.analysis.Stamp;

public class ZincScalaCompiler
implements Compiler<ScalaJavaJointCompileSpec> {
    private static final Logger LOGGER = Logging.getLogger(ZincScalaCompiler.class);
    private final ScalaInstance scalaInstance;
    private final ScalaCompiler scalaCompiler;
    private final AnalysisStoreProvider analysisStoreProvider;
    private final boolean leakCompilerClasspath;
    private final ClearableMapBackedCache<File, DefinesClass> definesClassCache = new ClearableMapBackedCache(new ConcurrentHashMap());

    @Inject
    public ZincScalaCompiler(ScalaInstance scalaInstance, ScalaCompiler scalaCompiler, AnalysisStoreProvider analysisStoreProvider, boolean leakCompilerClasspath) {
        this.scalaInstance = scalaInstance;
        this.scalaCompiler = scalaCompiler;
        this.analysisStoreProvider = analysisStoreProvider;
        this.leakCompilerClasspath = leakCompilerClasspath;
    }

    @Override
    public WorkResult execute(ScalaJavaJointCompileSpec spec) {
        Optional<TransactionalManagerType> classFileManagerType;
        Optional<Object> analysisStore;
        LOGGER.info("Compiling with Zinc Scala compiler.");
        Timer timer = Time.startTimer();
        IncrementalCompilerImpl incremental = new IncrementalCompilerImpl();
        Compilers compilers = incremental.compilers((xsbti.compile.ScalaInstance)this.scalaInstance, ClasspathOptionsUtil.boot(), Option.apply((Object)Jvm.current().getJavaHome()), this.scalaCompiler);
        List<String> scalacOptions = new ZincScalaCompilerArgumentsGenerator().generate(spec);
        List<String> javacOptions = new JavaCompilerArgumentsBuilder(spec).includeClasspath(false).noEmptySourcePath().build();
        File[] classpath = this.leakCompilerClasspath ? Iterables.toArray(Iterables.concat(Arrays.asList(this.scalaInstance.allJars()), spec.getCompileClasspath()), File.class) : Iterables.toArray(spec.getCompileClasspath(), File.class);
        CompileOptions compileOptions = CompileOptions.create().withSources(Iterables.toArray(spec.getSourceFiles(), File.class)).withClasspath(classpath).withScalacOptions(scalacOptions.toArray(new String[0])).withClassesDirectory(spec.getDestinationDir()).withJavacOptions(javacOptions.toArray(new String[0]));
        File analysisFile = spec.getAnalysisFile();
        if (spec.getScalaCompileOptions().isForce()) {
            analysisStore = Optional.empty();
            classFileManagerType = IncOptions.defaultClassFileManagerType();
        } else {
            analysisStore = Optional.of(this.analysisStoreProvider.get(analysisFile));
            classFileManagerType = Optional.of(TransactionalManagerType.of((File)spec.getClassfileBackupDir(), (xsbti.Logger)new SbtLoggerAdapter()));
        }
        PreviousResult previousResult = analysisStore.flatMap(store -> store.get().map(a -> PreviousResult.of(Optional.of(a.getAnalysis()), Optional.of(a.getMiniSetup())))).orElse(PreviousResult.of(Optional.empty(), Optional.empty()));
        IncOptions incOptions = IncOptions.of().withExternalHooks((ExternalHooks)new LookupOnlyExternalHooks((ExternalHooks.Lookup)new ExternalBinariesLookup())).withRecompileOnMacroDef(Optional.of(false)).withClassfileManagerType(classFileManagerType).withTransitiveStep(5);
        Setup setup = incremental.setup((PerClasspathEntryLookup)new EntryLookup(spec), false, analysisFile, CompilerCache.fresh(), incOptions, (Reporter)new LoggedReporter(100, (xsbti.Logger)new SbtLoggerAdapter(), p -> p), Option.empty(), ZincScalaCompiler.getExtra());
        Inputs inputs = incremental.inputs(compileOptions, compilers, setup, previousResult);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(inputs.toString());
        }
        if (spec.getScalaCompileOptions().isForce()) {
            GFileUtils.deleteDirectory(spec.getDestinationDir());
            GFileUtils.deleteQuietly(spec.getAnalysisFile());
        }
        LOGGER.info("Prepared Zinc Scala inputs: {}", (Object)timer.getElapsed());
        try {
            CompileResult compile = incremental.compile(inputs, (xsbti.Logger)new SbtLoggerAdapter());
            if (analysisStore.isPresent()) {
                AnalysisContents contentNext = AnalysisContents.create((CompileAnalysis)compile.analysis(), (MiniSetup)compile.setup());
                ((AnalysisStore)analysisStore.get()).set(contentNext);
            }
        }
        catch (CompileFailed e) {
            throw new CompilationFailedException(e);
        }
        LOGGER.info("Completed Scala compilation: {}", (Object)timer.getElapsed());
        return WorkResults.didWork(true);
    }

    private static T2<String, String>[] getExtra() {
        return new T2[0];
    }

    private static class ClearableMapBackedCache<K, V>
    extends MapBackedCache<K, V> {
        private final Map<K, V> map;

        public ClearableMapBackedCache(Map<K, V> map) {
            super(map);
            this.map = map;
        }

        public void clear() {
            this.map.clear();
        }
    }

    private static class AnalysisBakedDefineClass
    implements DefinesClass {
        private final Analysis analysis;

        public AnalysisBakedDefineClass(Analysis analysis) {
            this.analysis = analysis;
        }

        public boolean apply(String className) {
            return this.analysis.relations().productClassName().reverse((Object)className).nonEmpty();
        }
    }

    private static class LookupOnlyExternalHooks
    implements ExternalHooks {
        private final Optional<ExternalHooks.Lookup> lookup;

        public LookupOnlyExternalHooks(ExternalHooks.Lookup lookup) {
            this.lookup = Optional.of(lookup);
        }

        public Optional<ExternalHooks.Lookup> getExternalLookup() {
            return this.lookup;
        }

        public Optional<ClassFileManager> getExternalClassFileManager() {
            return Optional.empty();
        }

        public ExternalHooks withExternalClassFileManager(ClassFileManager externalClassFileManager) {
            return this;
        }

        public ExternalHooks withExternalLookup(ExternalHooks.Lookup externalLookup) {
            return this;
        }
    }

    private static class ExternalBinariesLookup
    implements ExternalLookup {
        private ExternalBinariesLookup() {
        }

        public <T> Option<T> none() {
            return None$.MODULE$;
        }

        public Option<Changes<File>> changedSources(CompileAnalysis previousAnalysis) {
            return this.none();
        }

        public Option<Set<File>> changedBinaries(CompileAnalysis previousAnalysis) {
            ArrayList<File> result = new ArrayList<File>();
            for (Map.Entry e : previousAnalysis.readStamps().getAllBinaryStamps().entrySet()) {
                if (((File)e.getKey()).exists() && ((Stamp)e.getValue()).equals(Stamper.forLastModified().apply((Object)((File)e.getKey())))) continue;
                result.add((File)e.getKey());
            }
            if (result.isEmpty()) {
                return new Some((Object)new HashSet());
            }
            return new Some((Object)JavaConverters.asScalaBuffer(result).toSet());
        }

        public Option<Set<File>> removedProducts(CompileAnalysis previousAnalysis) {
            return new Some((Object)new HashSet());
        }

        public boolean shouldDoIncrementalCompilation(Set<String> changedClasses, CompileAnalysis analysis) {
            return true;
        }

        public Optional<FileHash[]> hashClasspath(File[] classpath) {
            return Optional.empty();
        }
    }

    private class EntryLookup
    implements PerClasspathEntryLookup {
        private final Map<File, File> analysisMap = new HashMap<File, File>();

        public EntryLookup(ScalaJavaJointCompileSpec spec) {
            this.analysisMap.put(spec.getDestinationDir(), spec.getAnalysisFile());
            this.analysisMap.putAll(spec.getAnalysisMap());
        }

        public Optional<CompileAnalysis> analysis(File classpathEntry) {
            return Optional.ofNullable(this.analysisMap.get(classpathEntry)).flatMap(f -> ZincScalaCompiler.this.analysisStoreProvider.get((File)f).get().map(AnalysisContents::getAnalysis));
        }

        public DefinesClass definesClass(File classpathEntry) {
            return this.analysis(classpathEntry).map(a -> a instanceof Analysis ? (Analysis)a : null).map(AnalysisBakedDefineClass::new).orElseGet(() -> ZincScalaCompiler.this.definesClassCache.get(classpathEntry, Locate::definesClass));
        }
    }
}

