/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.tasks.scala.ScalaCompileSpec;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.language.scala.tasks.BaseScalaCompileOptions;

public class ZincScalaCompilerArgumentsGenerator {
    public List<String> generate(ScalaCompileSpec spec) {
        ArrayList<String> result = Lists.newArrayList();
        BaseScalaCompileOptions options = spec.getScalaCompileOptions();
        this.addFlag("-deprecation", options.isDeprecation(), result);
        this.addFlag("-unchecked", options.isUnchecked(), result);
        this.addConcatenatedOption("-g:", options.getDebugLevel(), result);
        this.addFlag("-optimise", options.isOptimize(), result);
        this.addOption("-encoding", options.getEncoding(), result);
        this.addFlag("-verbose", "verbose".equals(options.getDebugLevel()), result);
        this.addFlag("-Ydebug", "debug".equals(options.getDebugLevel()), result);
        if (options.getLoggingPhases() != null) {
            for (String phase : options.getLoggingPhases()) {
                this.addConcatenatedOption("-Ylog:", phase, result);
            }
        }
        if (options.getAdditionalParameters() != null) {
            result.addAll(options.getAdditionalParameters());
        }
        if (spec.getScalaCompilerPlugins() != null) {
            for (File plugin : spec.getScalaCompilerPlugins()) {
                result.add("-Xplugin:" + plugin.getPath());
            }
        }
        return result;
    }

    private void addFlag(String name, boolean value, List<String> result) {
        if (value) {
            result.add(name);
        }
    }

    private void addOption(String name, Object value, List<String> result) {
        if (value != null) {
            result.add(name);
            result.add(value.toString());
        }
    }

    private void addConcatenatedOption(String name, Object value, List<String> result) {
        if (value != null) {
            result.add(name + value.toString());
        }
    }
}

