/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import org.gradle.api.internal.tasks.testing.detection.AbstractTestFrameworkDetector;
import org.gradle.api.internal.tasks.testing.detection.ClassFileExtractionManager;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestClassDetector;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public class JUnitDetector
extends AbstractTestFrameworkDetector<JUnitTestClassDetector> {
    private static final String TEST_CASE = "junit/framework/TestCase";
    private static final String GROOVY_TEST_CASE = "groovy/util/GroovyTestCase";
    private static final ImmutableSet<String> KNOWN_TEST_CASE_CLASS_NAMES = ImmutableSet.of("org/gradle/internal/impldep/junit/framework/TestCase", "groovy/util/GroovyTestCase");

    public JUnitDetector(ClassFileExtractionManager classFileExtractionManager) {
        super(classFileExtractionManager);
    }

    @Override
    protected JUnitTestClassDetector createClassVisitor() {
        return new JUnitTestClassDetector(this);
    }

    @Override
    protected boolean isKnownTestCaseClassName(String testCaseClassName) {
        return KNOWN_TEST_CASE_CLASS_NAMES.contains(testCaseClassName);
    }
}

