/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.logging;

import java.util.List;
import org.gradle.api.internal.tasks.testing.logging.ClassMethodNameStackTraceSpec;
import org.gradle.api.internal.tasks.testing.logging.StackTraceFilter;
import org.gradle.api.internal.tasks.testing.logging.TestExceptionFormatter;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.logging.TestLogging;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.serialize.PlaceholderExceptionSupport;

public class ShortExceptionFormatter
implements TestExceptionFormatter {
    private static final String INDENT = "    ";
    private final TestLogging testLogging;

    public ShortExceptionFormatter(TestLogging testLogging) {
        this.testLogging = testLogging;
    }

    @Override
    public String format(TestDescriptor descriptor, List<Throwable> exceptions) {
        StringBuilder builder = new StringBuilder();
        for (Throwable exception : exceptions) {
            this.printException(descriptor, exception, false, 1, builder);
        }
        return builder.toString();
    }

    private void printException(TestDescriptor descriptor, Throwable exception, boolean cause, int indentLevel, StringBuilder builder) {
        String indent = Strings.repeat(INDENT, indentLevel);
        builder.append(indent);
        if (cause) {
            builder.append("Caused by: ");
        }
        String className = exception instanceof PlaceholderExceptionSupport ? ((PlaceholderExceptionSupport)((Object)exception)).getExceptionClassName() : exception.getClass().getName();
        builder.append(className);
        StackTraceFilter filter = new StackTraceFilter(new ClassMethodNameStackTraceSpec(descriptor.getClassName(), null));
        List<StackTraceElement> stackTrace = filter.filter(exception);
        if (stackTrace.size() > 0) {
            StackTraceElement element = stackTrace.get(0);
            builder.append(" at ");
            builder.append(element.getFileName());
            builder.append(':');
            builder.append(element.getLineNumber());
        }
        builder.append('\n');
        if (this.testLogging.getShowCauses() && exception.getCause() != null) {
            this.printException(descriptor, exception.getCause(), true, indentLevel + 1, builder);
        }
    }
}

