/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.testng;

import java.util.Set;
import org.gradle.api.internal.tasks.testing.detection.TestClassVisitor;
import org.gradle.api.internal.tasks.testing.detection.TestFrameworkDetector;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.org.objectweb.asm.AnnotationVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.MethodVisitor;

class TestNGTestClassDetector
extends TestClassVisitor {
    private static final Set<String> TEST_METHOD_ANNOTATIONS = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("Lorg/testng/annotations/Test;")).add("Lorg/testng/annotations/BeforeSuite;")).add("Lorg/testng/annotations/AfterSuite;")).add("Lorg/testng/annotations/BeforeTest;")).add("Lorg/testng/annotations/AfterTest;")).add("Lorg/testng/annotations/BeforeGroups;")).add("Lorg/testng/annotations/AfterGroups;")).add("Lorg/testng/annotations/Factory;")).build();

    TestNGTestClassDetector(TestFrameworkDetector detector) {
        super(detector);
    }

    @Override
    protected boolean ignoreNonStaticInnerClass() {
        return false;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if ("Lorg/testng/annotations/Test;".equals(desc)) {
            this.setTest(true);
        }
        return null;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (!this.isAbstract() && !this.isTest()) {
            return new TestNGTestMethodDetector();
        }
        return null;
    }

    private class TestNGTestMethodDetector
    extends MethodVisitor {
        private TestNGTestMethodDetector() {
            super(458752);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (TEST_METHOD_ANNOTATIONS.contains(desc)) {
                TestNGTestClassDetector.this.setTest(true);
            }
            return null;
        }
    }
}

