/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.File;
import java.util.function.BiFunction;
import javax.inject.Inject;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.DefaultGroovySourceSet;
import org.gradle.api.internal.tasks.DefaultSourceSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.jvm.internal.JvmEcosystemUtilities;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.GroovyRuntime;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.GroovyCompile;
import org.gradle.api.tasks.javadoc.Groovydoc;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;

public class GroovyBasePlugin
implements Plugin<Project> {
    public static final String GROOVY_RUNTIME_EXTENSION_NAME = "groovyRuntime";
    private final ObjectFactory objectFactory;
    private final ModuleRegistry moduleRegistry;
    private final JvmPluginServices jvmPluginServices;
    private Project project;
    private GroovyRuntime groovyRuntime;

    @Inject
    public GroovyBasePlugin(ObjectFactory objectFactory, ModuleRegistry moduleRegistry, JvmEcosystemUtilities jvmPluginServices) {
        this.objectFactory = objectFactory;
        this.moduleRegistry = moduleRegistry;
        this.jvmPluginServices = (JvmPluginServices)jvmPluginServices;
    }

    @Override
    public void apply(Project project) {
        this.project = project;
        project.getPluginManager().apply(JavaBasePlugin.class);
        this.configureGroovyRuntimeExtension();
        this.configureCompileDefaults();
        this.configureSourceSetDefaults();
        this.configureGroovydoc();
    }

    private void configureGroovyRuntimeExtension() {
        this.groovyRuntime = this.project.getExtensions().create(GROOVY_RUNTIME_EXTENSION_NAME, GroovyRuntime.class, this.project);
    }

    private void configureCompileDefaults() {
        this.project.getTasks().withType(GroovyCompile.class).configureEach(compile -> compile.getConventionMapping().map("groovyClasspath", () -> this.groovyRuntime.inferGroovyClasspath(compile.getClasspath())));
    }

    private void configureSourceSetDefaults() {
        this.project.getConvention().getPlugin(JavaPluginConvention.class).getSourceSets().all(sourceSet -> {
            DefaultGroovySourceSet groovySourceSet = new DefaultGroovySourceSet("groovy", ((DefaultSourceSet)sourceSet).getDisplayName(), this.objectFactory);
            new DslObject(sourceSet).getConvention().getPlugins().put("groovy", groovySourceSet);
            SourceDirectorySet groovySource = groovySourceSet.getGroovy();
            groovySource.srcDir("src/" + sourceSet.getName() + "/groovy");
            SourceDirectorySet groovySourceFiles = groovySource;
            sourceSet.getResources().getFilter().exclude(SerializableLambdas.spec(element -> groovySourceFiles.contains(element.getFile())));
            sourceSet.getAllJava().source(groovySource);
            sourceSet.getAllSource().source(groovySource);
            NamedDomainObjectProvider compileTask = this.project.getTasks().register(sourceSet.getCompileTaskName("groovy"), GroovyCompile.class, compile -> {
                JvmPluginsHelper.configureForSourceSet(sourceSet, groovySource, compile, compile.getOptions(), this.project);
                compile.setDescription("Compiles the " + sourceSet.getName() + " Groovy source.");
                compile.setSource(groovySource);
                compile.getJavaLauncher().convention(this.getToolchainTool(this.project, JavaToolchainService::launcherFor));
            });
            JvmPluginsHelper.configureOutputDirectoryForSourceSet(sourceSet, groovySource, this.project, (TaskProvider<? extends AbstractCompile>)compileTask, compileTask.map(GroovyCompile::getOptions));
            this.jvmPluginServices.useDefaultTargetPlatformInference(this.project.getConfigurations().getByName(sourceSet.getCompileClasspathConfigurationName()), compileTask);
            this.jvmPluginServices.useDefaultTargetPlatformInference(this.project.getConfigurations().getByName(sourceSet.getRuntimeClasspathConfigurationName()), compileTask);
            this.project.getTasks().named(sourceSet.getClassesTaskName(), arg_0 -> GroovyBasePlugin.lambda$configureSourceSetDefaults$3((TaskProvider)compileTask, arg_0));
            this.project.getConfigurations().getByName(sourceSet.getCompileClasspathConfigurationName()).attributes(attrs -> attrs.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, this.project.getObjects().named(LibraryElements.class, "classes+resources")));
        });
    }

    private void configureGroovydoc() {
        this.project.getTasks().withType(Groovydoc.class).configureEach(groovydoc -> {
            groovydoc.getConventionMapping().map("groovyClasspath", () -> {
                FileCollection groovyClasspath = this.groovyRuntime.inferGroovyClasspath(groovydoc.getClasspath());
                ConfigurableFileCollection jansi = this.project.getObjects().fileCollection().from(this.moduleRegistry.getExternalModule("jansi").getImplementationClasspath().getAsFiles());
                return groovyClasspath.plus(jansi);
            });
            groovydoc.getConventionMapping().map("destinationDir", () -> new File(this.java(this.project.getConvention()).getDocsDir(), "groovydoc"));
            groovydoc.getConventionMapping().map("docTitle", () -> this.project.getExtensions().getByType(ReportingExtension.class).getApiDocTitle());
            groovydoc.getConventionMapping().map("windowTitle", () -> this.project.getExtensions().getByType(ReportingExtension.class).getApiDocTitle());
        });
    }

    private JavaPluginConvention java(Convention convention) {
        return convention.getPlugin(JavaPluginConvention.class);
    }

    private <T> Provider<T> getToolchainTool(Project project, BiFunction<JavaToolchainService, JavaToolchainSpec, Provider<T>> toolMapper) {
        JavaPluginExtension extension = project.getExtensions().getByType(JavaPluginExtension.class);
        JavaToolchainService service = project.getExtensions().getByType(JavaToolchainService.class);
        return toolMapper.apply(service, extension.getToolchain());
    }

    private static /* synthetic */ void lambda$configureSourceSetDefaults$3(TaskProvider compileTask, Task task) {
        task.dependsOn(compileTask);
    }
}

