/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import java.util.List;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.plugins.internal.FeatureSpecInternal;
import org.gradle.api.plugins.jvm.internal.JvmModelingServices;
import org.gradle.api.plugins.jvm.internal.JvmVariantBuilderInternal;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

public class DefaultJavaFeatureSpec
implements FeatureSpecInternal {
    private final String name;
    private final List<Capability> capabilities = Lists.newArrayListWithExpectedSize(2);
    private final JvmModelingServices jvmEcosystemUtilities;
    private boolean overrideDefaultCapability = true;
    private SourceSet sourceSet;
    private boolean withJavadocJar = false;
    private boolean withSourcesJar = false;
    private boolean allowPublication = true;

    public DefaultJavaFeatureSpec(String name, Capability defaultCapability, JvmModelingServices jvmModelingServices) {
        this.name = name;
        this.jvmEcosystemUtilities = jvmModelingServices;
        this.capabilities.add(defaultCapability);
    }

    @Override
    public void usingSourceSet(SourceSet sourceSet) {
        this.sourceSet = sourceSet;
    }

    @Override
    public void capability(String group, String name, String version) {
        if (this.overrideDefaultCapability) {
            this.capabilities.clear();
            this.overrideDefaultCapability = false;
        }
        this.capabilities.add(new ImmutableCapability(group, name, version));
    }

    @Override
    public void create() {
        this.setupConfigurations(this.sourceSet);
    }

    @Override
    public void withJavadocJar() {
        this.withJavadocJar = true;
    }

    @Override
    public void withSourcesJar() {
        this.withSourcesJar = true;
    }

    @Override
    public void disablePublication() {
        this.allowPublication = false;
    }

    private void setupConfigurations(SourceSet sourceSet) {
        if (sourceSet == null) {
            throw new InvalidUserCodeException("You must specify which source set to use for feature '" + this.name + "'");
        }
        this.jvmEcosystemUtilities.createJvmVariant(this.name, builder -> {
            builder.usingSourceSet(sourceSet).withDisplayName("feature " + this.name).exposesApi();
            if (this.withJavadocJar) {
                builder.withJavadocJar();
            }
            if (this.withSourcesJar) {
                builder.withSourcesJar();
            }
            if (this.allowPublication) {
                builder.published();
            }
            for (Capability capability : this.capabilities) {
                ((JvmVariantBuilderInternal)builder).capability(capability);
            }
        });
    }
}

