/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import java.util.regex.Pattern;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.jvm.ModularitySpec;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.FeatureSpec;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.JavaResolutionConsistency;
import org.gradle.api.plugins.internal.DefaultJavaFeatureSpec;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.component.external.model.ProjectDerivedCapability;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.jvm.DefaultModularitySpec;
import org.gradle.jvm.toolchain.JavaToolchainSpec;

public class DefaultJavaPluginExtension
implements JavaPluginExtension {
    private static final Pattern VALID_FEATURE_NAME = Pattern.compile("[a-zA-Z0-9]+");
    private final JavaPluginConvention convention;
    private final ObjectFactory objectFactory;
    private final SoftwareComponentContainer components;
    private final Project project;
    private final ModularitySpec modularity;
    private final JvmPluginServices jvmPluginServices;
    private final JavaToolchainSpec toolchain;

    public DefaultJavaPluginExtension(JavaPluginConvention convention, Project project, JvmPluginServices jvmPluginServices, JavaToolchainSpec toolchainSpec) {
        this.convention = convention;
        this.objectFactory = project.getObjects();
        this.components = project.getComponents();
        this.project = project;
        this.modularity = this.objectFactory.newInstance(DefaultModularitySpec.class, new Object[0]);
        this.jvmPluginServices = jvmPluginServices;
        this.toolchain = toolchainSpec;
    }

    @Override
    public JavaVersion getSourceCompatibility() {
        return this.convention.getSourceCompatibility();
    }

    @Override
    public void setSourceCompatibility(JavaVersion value) {
        this.convention.setSourceCompatibility(value);
    }

    @Override
    public JavaVersion getTargetCompatibility() {
        return this.convention.getTargetCompatibility();
    }

    @Override
    public void setTargetCompatibility(JavaVersion value) {
        this.convention.setTargetCompatibility(value);
    }

    @Override
    public void registerFeature(String name, Action<? super FeatureSpec> configureAction) {
        ProjectDerivedCapability defaultCapability = new ProjectDerivedCapability(this.project, name);
        DefaultJavaFeatureSpec spec = new DefaultJavaFeatureSpec(DefaultJavaPluginExtension.validateFeatureName(name), defaultCapability, this.jvmPluginServices);
        configureAction.execute(spec);
        spec.create();
    }

    @Override
    public void disableAutoTargetJvm() {
        this.convention.disableAutoTargetJvm();
    }

    @Override
    public void withJavadocJar() {
        TaskContainer tasks = this.project.getTasks();
        ConfigurationContainer configurations = this.project.getConfigurations();
        SourceSet main = (SourceSet)this.convention.getSourceSets().getByName("main");
        JvmPluginsHelper.configureDocumentationVariantWithArtifact("javadocElements", null, "javadoc", ImmutableList.of(), main.getJavadocJarTaskName(), tasks.named(main.getJavadocTaskName()), JvmPluginsHelper.findJavaComponent(this.components), configurations, tasks, this.objectFactory);
    }

    @Override
    public void withSourcesJar() {
        TaskContainer tasks = this.project.getTasks();
        ConfigurationContainer configurations = this.project.getConfigurations();
        SourceSet main = (SourceSet)this.convention.getSourceSets().getByName("main");
        JvmPluginsHelper.configureDocumentationVariantWithArtifact("sourcesElements", null, "sources", ImmutableList.of(), main.getSourcesJarTaskName(), main.getAllSource(), JvmPluginsHelper.findJavaComponent(this.components), configurations, tasks, this.objectFactory);
    }

    @Override
    public ModularitySpec getModularity() {
        return this.modularity;
    }

    @Override
    public JavaToolchainSpec getToolchain() {
        return this.toolchain;
    }

    @Override
    public JavaToolchainSpec toolchain(Action<? super JavaToolchainSpec> action) {
        action.execute(this.toolchain);
        return this.toolchain;
    }

    @Override
    public void consistentResolution(Action<? super JavaResolutionConsistency> action) {
        ConfigurationContainer configurations = this.project.getConfigurations();
        SourceSetContainer sourceSets = this.convention.getSourceSets();
        action.execute(this.project.getObjects().newInstance(DefaultJavaResolutionConsistency.class, sourceSets, configurations));
    }

    private static String validateFeatureName(String name) {
        if (!VALID_FEATURE_NAME.matcher(name).matches()) {
            throw new InvalidUserDataException("Invalid feature name '" + name + "'. Must match " + VALID_FEATURE_NAME.pattern());
        }
        return name;
    }

    public static class DefaultJavaResolutionConsistency
    implements JavaResolutionConsistency {
        private final Configuration mainCompileClasspath;
        private final Configuration mainRuntimeClasspath;
        private final Configuration testCompileClasspath;
        private final Configuration testRuntimeClasspath;
        private final SourceSetContainer sourceSets;
        private final ConfigurationContainer configurations;

        @Inject
        public DefaultJavaResolutionConsistency(SourceSetContainer sourceSets, ConfigurationContainer configurations) {
            this.sourceSets = sourceSets;
            this.configurations = configurations;
            SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
            SourceSet testSourceSet = (SourceSet)sourceSets.getByName("test");
            this.mainCompileClasspath = this.findConfiguration(mainSourceSet.getCompileClasspathConfigurationName());
            this.mainRuntimeClasspath = this.findConfiguration(mainSourceSet.getRuntimeClasspathConfigurationName());
            this.testCompileClasspath = this.findConfiguration(testSourceSet.getCompileClasspathConfigurationName());
            this.testRuntimeClasspath = this.findConfiguration(testSourceSet.getRuntimeClasspathConfigurationName());
        }

        @Override
        public void useCompileClasspathVersions() {
            this.sourceSets.configureEach(this::applyCompileClasspathConsistency);
            this.testCompileClasspath.shouldResolveConsistentlyWith(this.mainCompileClasspath);
        }

        @Override
        public void useRuntimeClasspathVersions() {
            this.sourceSets.configureEach(this::applyRuntimeClasspathConsistency);
            this.testRuntimeClasspath.shouldResolveConsistentlyWith(this.mainRuntimeClasspath);
        }

        private void applyCompileClasspathConsistency(SourceSet sourceSet) {
            Configuration compileClasspath = this.findConfiguration(sourceSet.getCompileClasspathConfigurationName());
            Configuration runtimeClasspath = this.findConfiguration(sourceSet.getRuntimeClasspathConfigurationName());
            runtimeClasspath.shouldResolveConsistentlyWith(compileClasspath);
        }

        private void applyRuntimeClasspathConsistency(SourceSet sourceSet) {
            Configuration compileClasspath = this.findConfiguration(sourceSet.getCompileClasspathConfigurationName());
            Configuration runtimeClasspath = this.findConfiguration(sourceSet.getRuntimeClasspathConfigurationName());
            compileClasspath.shouldResolveConsistentlyWith(runtimeClasspath);
        }

        private Configuration findConfiguration(String configName) {
            return this.configurations.getByName(configName);
        }
    }
}

