/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jvm.internal;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.plugins.jvm.internal.JvmEcosystemAttributesDetails;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

abstract class AbstractConfigurationBuilder<T extends AbstractConfigurationBuilder<T>> {
    final String name;
    final JvmPluginServices jvmEcosystemUtilities;
    final ConfigurationContainer configurations;
    String description;
    List<Object> extendsFrom;
    Action<? super JvmEcosystemAttributesDetails> attributesRefiner;

    public AbstractConfigurationBuilder(String name, JvmPluginServices jvmEcosystemUtilities, ConfigurationContainer configurations) {
        this.name = name;
        this.jvmEcosystemUtilities = jvmEcosystemUtilities;
        this.configurations = configurations;
    }

    abstract Configuration build();

    @Nullable
    protected Configuration[] buildExtendsFrom() {
        if (this.extendsFrom == null) {
            return null;
        }
        Configuration[] out = new Configuration[this.extendsFrom.size()];
        int i = 0;
        for (Object obj : this.extendsFrom) {
            if (obj instanceof Configuration) {
                out[i] = (Configuration)obj;
            } else if (obj instanceof Provider) {
                out[i] = (Configuration)((Provider)Cast.uncheckedCast(obj)).get();
            } else {
                throw new IllegalStateException("Unexpected configuration provider type: " + obj);
            }
            ++i;
        }
        return out;
    }

    public T withDescription(String description) {
        this.description = description;
        return (T)((AbstractConfigurationBuilder)Cast.uncheckedCast(this));
    }

    public T extendsFrom(Configuration ... parentConfigurations) {
        if (this.extendsFrom == null) {
            this.extendsFrom = Lists.newArrayListWithExpectedSize(parentConfigurations.length);
        }
        Collections.addAll(this.extendsFrom, parentConfigurations);
        return (T)((AbstractConfigurationBuilder)Cast.uncheckedCast(this));
    }

    public final T extendsFrom(List<Provider<Configuration>> parentConfigurations) {
        if (this.extendsFrom == null) {
            this.extendsFrom = Lists.newArrayListWithExpectedSize(parentConfigurations.size());
        }
        this.extendsFrom.addAll(parentConfigurations);
        return (T)((AbstractConfigurationBuilder)Cast.uncheckedCast(this));
    }

    protected T attributes(Action<? super JvmEcosystemAttributesDetails> refiner) {
        this.attributesRefiner = refiner;
        return (T)((AbstractConfigurationBuilder)Cast.uncheckedCast(this));
    }
}

