/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jvm.internal;

import java.util.function.Function;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultSourceSetOutput;
import org.gradle.api.plugins.jvm.internal.JvmLanguageGeneratedSourceDirectoryBuilder;
import org.gradle.api.plugins.jvm.internal.JvmLanguageSourceDirectoryBuilder;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;

public class DefaultJvmLanguageGeneratedSourceDirectoryBuilder
implements JvmLanguageGeneratedSourceDirectoryBuilder {
    private final ProjectInternal project;
    private final SourceSet sourceSet;
    private String description;
    private Action<? super JvmLanguageSourceDirectoryBuilder.CompileTaskDetails> taskBuilder;
    private TaskProvider<? extends Task> sourceTaskProvider;
    private Function<? extends Task, DirectoryProperty> mapping;
    private boolean includeInAllJava;

    @Inject
    public DefaultJvmLanguageGeneratedSourceDirectoryBuilder(ProjectInternal project, SourceSet sourceSet) {
        this.project = project;
        this.sourceSet = sourceSet;
    }

    @Override
    public JvmLanguageSourceDirectoryBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public JvmLanguageSourceDirectoryBuilder compiledBy(Action<? super JvmLanguageSourceDirectoryBuilder.CompileTaskDetails> taskBuilder) {
        this.taskBuilder = taskBuilder;
        return this;
    }

    @Override
    public JvmLanguageSourceDirectoryBuilder compiledWithJava(Action<? super JavaCompile> compilerConfiguration) {
        this.includeInAllJava();
        return this.doCompileWithJava(compilerConfiguration);
    }

    private JvmLanguageSourceDirectoryBuilder doCompileWithJava(Action<? super JavaCompile> compilerConfiguration) {
        return this.compiledBy(details -> {
            String compileTaskName = "compile" + StringUtils.capitalize(this.sourceTaskProvider.getName());
            NamedDomainObjectProvider taskProvider = this.project.getTasks().register(compileTaskName, JavaCompile.class, compileTask -> {
                compileTask.setDescription("Compile task for " + this.description);
                compileTask.source(details.getSourceDirectory());
                compileTask.setClasspath(this.sourceSet.getCompileClasspath());
                compileTask.setDestinationDir(this.project.getLayout().getBuildDirectory().dir("classes/" + compileTaskName + "/" + this.sourceSet.getName()).map(Directory::getAsFile));
                compilerConfiguration.execute((JavaCompile)compileTask);
            });
            details.setCompileTask((TaskProvider<? extends Task>)taskProvider, AbstractCompile::getDestinationDirectory);
        });
    }

    @Override
    public JvmLanguageSourceDirectoryBuilder includeInAllJava() {
        this.includeInAllJava = true;
        return this;
    }

    void build() {
        if (this.taskBuilder == null) {
            throw new IllegalStateException("You must specify how sources will be compiled either by calling compiledWithJava or compiledBy");
        }
        if (this.mapping == null) {
            throw new IllegalStateException("You must specify the mapping function from your source generating task to a directory property");
        }
        if (this.sourceTaskProvider == null) {
            throw new IllegalStateException("You must specify the source generation task");
        }
        Provider sourceDirectory = this.sourceTaskProvider.flatMap(task -> this.mapping.apply((Task)Cast.uncheckedCast(task)));
        DefaultCompileTaskDetails details = this.createTaskDetails((DirectoryProperty)this.project.getObjects().directoryProperty().convention(sourceDirectory));
        DefaultSourceSetOutput sourceSetOutput = Cast.cast(DefaultSourceSetOutput.class, this.sourceSet.getOutput());
        sourceSetOutput.addClassesDir(details.compileTask.flatMap(task -> (Provider)details.compileMapping.apply((Task)Cast.uncheckedCast(task))));
        sourceSetOutput.registerClassesContributor(details.compileTask);
        sourceSetOutput.getGeneratedSourcesDirs().from(sourceDirectory);
        this.project.getTasks().matching(DefaultJvmLanguageGeneratedSourceDirectoryBuilder::isClassesTask).configureEach(classes -> classes.dependsOn(details.compileTask));
        if (this.includeInAllJava) {
            this.sourceSet.getAllJava().srcDir(sourceDirectory);
        }
        this.sourceSet.getAllSource().srcDir(sourceDirectory);
    }

    private static boolean isClassesTask(Task t) {
        return "classes".equals(t.getName());
    }

    private DefaultCompileTaskDetails createTaskDetails(DirectoryProperty sources) {
        DefaultCompileTaskDetails details = new DefaultCompileTaskDetails(sources);
        this.taskBuilder.execute(details);
        return details;
    }

    @Override
    public <T extends Task> JvmLanguageGeneratedSourceDirectoryBuilder forSourceGeneratingTask(TaskProvider<T> taskProvider, Function<T, DirectoryProperty> mapping) {
        this.sourceTaskProvider = taskProvider;
        this.mapping = mapping;
        return this;
    }

    private static class DefaultCompileTaskDetails
    implements JvmLanguageSourceDirectoryBuilder.CompileTaskDetails {
        private final DirectoryProperty sourceDirectory;
        private TaskProvider<? extends Task> compileTask;
        private Function<? extends Task, DirectoryProperty> compileMapping;

        public DefaultCompileTaskDetails(DirectoryProperty sourceDirectory) {
            this.sourceDirectory = sourceDirectory;
        }

        @Override
        public DirectoryProperty getSourceDirectory() {
            return this.sourceDirectory;
        }

        @Override
        public <T extends Task> void setCompileTask(TaskProvider<? extends Task> task, Function<T, DirectoryProperty> mapping) {
            this.compileTask = task;
            this.compileMapping = mapping;
        }
    }
}

