/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jvm.internal;

import java.util.function.Function;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.compile.HasCompileOptions;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.jvm.internal.JvmLanguageSourceDirectoryBuilder;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;

public class DefaultJvmLanguageSourceDirectoryBuilder
implements JvmLanguageSourceDirectoryBuilder {
    private final String name;
    private final ProjectInternal project;
    private final SourceSet sourceSet;
    private String description;
    private Action<? super JvmLanguageSourceDirectoryBuilder.CompileTaskDetails> taskBuilder;
    private boolean includeInAllJava;

    @Inject
    public DefaultJvmLanguageSourceDirectoryBuilder(String name, ProjectInternal project, SourceSet sourceSet) {
        this.name = name;
        this.project = project;
        this.sourceSet = sourceSet;
    }

    @Override
    public JvmLanguageSourceDirectoryBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public JvmLanguageSourceDirectoryBuilder compiledBy(Action<? super JvmLanguageSourceDirectoryBuilder.CompileTaskDetails> taskBuilder) {
        this.taskBuilder = taskBuilder;
        return this;
    }

    @Override
    public JvmLanguageSourceDirectoryBuilder compiledWithJava(Action<? super JavaCompile> compilerConfiguration) {
        return this.includeInAllJava().compiledBy(details -> {
            NamedDomainObjectProvider taskProvider = this.project.getTasks().register("compile" + StringUtils.capitalize(this.name), JavaCompile.class, compileTask -> {
                compileTask.source(details.getSourceDirectory());
                compileTask.setClasspath(this.sourceSet.getCompileClasspath());
                compilerConfiguration.execute((JavaCompile)compileTask);
            });
            details.setCompileTask((TaskProvider<? extends Task>)taskProvider, AbstractCompile::getDestinationDirectory);
        });
    }

    @Override
    public JvmLanguageSourceDirectoryBuilder includeInAllJava() {
        this.includeInAllJava = true;
        return this;
    }

    void build() {
        if (this.taskBuilder == null) {
            throw new IllegalStateException("You must specify the task which will contribute classes from this source directory");
        }
        SourceDirectorySet langSrcDir = this.project.getObjects().sourceDirectorySet(this.name, this.description == null ? "Sources for " + this.name : this.description);
        langSrcDir.srcDir("src/" + this.sourceSet.getName() + "/" + this.name);
        DefaultCompileTaskDetails details = this.createTaskDetails(langSrcDir);
        JvmPluginsHelper.configureOutputDirectoryForSourceSet(this.sourceSet, langSrcDir, this.project, details.task, details.task.map(task -> {
            if (task instanceof HasCompileOptions) {
                return ((HasCompileOptions)((Object)task)).getOptions();
            }
            throw new UnsupportedOperationException("Unsupported compile task " + task.getClass().getName());
        }), (Function)Cast.uncheckedCast(details.mapping));
        if (this.includeInAllJava) {
            this.sourceSet.getAllJava().source(langSrcDir);
        }
        this.sourceSet.getAllSource().source(langSrcDir);
        this.project.getTasks().named("classes").configure(classes -> classes.dependsOn(details.task));
    }

    private DefaultCompileTaskDetails createTaskDetails(SourceDirectorySet langSrcDir) {
        DefaultCompileTaskDetails details = new DefaultCompileTaskDetails((DirectoryProperty)this.project.getObjects().directoryProperty().fileProvider((Provider)this.project.getProviders().provider(() -> langSrcDir.getSourceDirectories().getSingleFile())));
        this.taskBuilder.execute(details);
        return details;
    }

    private static class DefaultCompileTaskDetails
    implements JvmLanguageSourceDirectoryBuilder.CompileTaskDetails {
        private final DirectoryProperty langSrcDir;
        private TaskProvider<? extends Task> task;
        private Function<? extends Task, DirectoryProperty> mapping;

        public DefaultCompileTaskDetails(DirectoryProperty langSrcDir) {
            this.langSrcDir = langSrcDir;
        }

        @Override
        public DirectoryProperty getSourceDirectory() {
            return this.langSrcDir;
        }

        @Override
        public <T extends Task> void setCompileTask(TaskProvider<? extends Task> task, Function<T, DirectoryProperty> mapping) {
            this.task = task;
            this.mapping = mapping;
        }
    }
}

